/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.util.VersionInfo;

public final class ICUDebug {
    private static String params;
    private static boolean debug;
    private static boolean help;
    public static final String javaVersionString;
    public static final boolean isJDK14OrHigher;
    public static final VersionInfo javaVersion;

    static {
        VersionInfo java14Version;
        try {
            params = System.getProperty("ICUDebug");
        }
        catch (SecurityException securityException) {}
        debug = params != null;
        boolean bl = help = debug && (params.equals("") || params.indexOf("help") != -1);
        if (debug) {
            System.out.println("\nICUDebug=" + params);
        }
        isJDK14OrHigher = (javaVersion = ICUDebug.getInstanceLenient(javaVersionString = System.getProperty("java.version"))).compareTo(java14Version = VersionInfo.getInstance("1.4.0")) >= 0;
    }

    public static VersionInfo getInstanceLenient(String s) {
        char[] chars = s.toCharArray();
        int r = 0;
        int w = 0;
        int count = 0;
        boolean numeric = false;
        while (r < chars.length) {
            char c;
            if ((c = chars[r++]) < '0' || c > '9') {
                if (!numeric) continue;
                if (count == 3) break;
                numeric = false;
                chars[w++] = 46;
                ++count;
                continue;
            }
            numeric = true;
            chars[w++] = c;
        }
        while (w > 0 && chars[w - 1] == '.') {
            --w;
        }
        String vs = new String(chars, 0, w);
        return VersionInfo.getInstance(vs);
    }

    public static boolean enabled() {
        return debug;
    }

    public static boolean enabled(String arg) {
        if (debug) {
            boolean result;
            boolean bl = result = params.indexOf(arg) != -1;
            if (help) {
                System.out.println("\nICUDebug.enabled(" + arg + ") = " + result);
            }
            return result;
        }
        return false;
    }

    public static String value(String arg) {
        String result = "false";
        if (debug) {
            int index = params.indexOf(arg);
            if (index != -1) {
                int limit;
                result = params.length() > (index += arg.length()) && params.charAt(index) == '=' ? params.substring(index, (limit = params.indexOf(",", ++index)) == -1 ? params.length() : limit) : "true";
            }
            if (help) {
                System.out.println("\nICUDebug.value(" + arg + ") = " + result);
            }
        }
        return result;
    }
}

