/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.actions.IVariableValueEditor;

public class VariableValueEditorManager {
    private Map fEditorMap = new HashMap();
    private static VariableValueEditorManager fgManager;

    private VariableValueEditorManager() {
        this.loadVariableEditors();
    }

    public static VariableValueEditorManager getDefault() {
        if (fgManager == null) {
            fgManager = new VariableValueEditorManager();
        }
        return fgManager;
    }

    public IVariableValueEditor getVariableValueEditor(String modelIdentifier) {
        Object object = this.fEditorMap.get(modelIdentifier);
        IVariableValueEditor editor = null;
        if (object instanceof IVariableValueEditor) {
            editor = (IVariableValueEditor)object;
        } else if (object instanceof IConfigurationElement) {
            try {
                editor = (IVariableValueEditor)((IConfigurationElement)object).createExecutableExtension("class");
                this.fEditorMap.put(modelIdentifier, editor);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return editor;
    }

    private void loadVariableEditors() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "variableValueEditors");
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String modelId = element.getAttribute("modelId");
            if (modelId != null) {
                this.fEditorMap.put(modelId, element);
            }
            ++i;
        }
    }
}

