/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class DeleteLaunchConfigurationAction
extends AbstractLaunchConfigurationAction {
    public static final String ID_DELETE_ACTION = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".ID_DELETE_ACTION";

    public DeleteLaunchConfigurationAction(Viewer viewer, String mode) {
        super(LaunchConfigurationsMessages.DeleteLaunchConfigurationAction_Dele_te_1, viewer, mode);
    }

    protected boolean shouldDelete() {
        IStructuredSelection selection = this.getStructuredSelection();
        String dialogMessage = selection.size() > 1 ? LaunchConfigurationsMessages.LaunchConfigurationDialog_Do_you_wish_to_delete_the_selected_launch_configurations__1 : LaunchConfigurationsMessages.LaunchConfigurationDialog_Do_you_wish_to_delete_the_selected_launch_configuration__2;
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchConfigurationsMessages.LaunchConfigurationDialog_Confirm_Launch_Configuration_Deletion_3, (String)dialogMessage);
    }

    protected void performAction() {
        if (!this.shouldDelete()) {
            return;
        }
        IStructuredSelection selection = this.getStructuredSelection();
        this.getViewer().getControl().setRedraw(false);
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            ILaunchConfiguration configuration = (ILaunchConfiguration)iterator.next();
            try {
                configuration.delete();
            }
            catch (CoreException e) {
                this.errorDialog(e);
            }
        }
        this.getViewer().getControl().setRedraw(true);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator items = selection.iterator();
        while (items.hasNext()) {
            if (items.next() instanceof ILaunchConfiguration) continue;
            return false;
        }
        return true;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_DLCL_DELETE_CONFIG");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_ELCL_DELETE_CONFIG");
    }

    public String getToolTipText() {
        return LaunchConfigurationsMessages.LaunchConfigurationsDialog_1;
    }
}

