/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.LaunchConfigurationTabExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupWrapper;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchTabContribution;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LaunchConfigurationPresentationManager {
    private static LaunchConfigurationPresentationManager fgDefault;
    private Hashtable fTabGroupExtensions;
    private Hashtable fContributedTabs;

    private LaunchConfigurationPresentationManager() {
        fgDefault = this;
    }

    public static LaunchConfigurationPresentationManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new LaunchConfigurationPresentationManager();
        }
        return fgDefault;
    }

    private void initializeTabGroupExtensions() {
        if (this.fTabGroupExtensions == null) {
            this.fTabGroupExtensions = new Hashtable();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "launchConfigurationTabGroups");
            IConfigurationElement[] groups = extensionPoint.getConfigurationElements();
            LaunchConfigurationTabGroupExtension group = null;
            String typeId = null;
            Hashtable<String, LaunchConfigurationTabGroupExtension> map = null;
            List modes = null;
            int i = 0;
            while (i < groups.length) {
                group = new LaunchConfigurationTabGroupExtension(groups[i]);
                typeId = group.getTypeIdentifier();
                map = (Hashtable<String, LaunchConfigurationTabGroupExtension>)this.fTabGroupExtensions.get(typeId);
                if (map == null) {
                    map = new Hashtable<String, LaunchConfigurationTabGroupExtension>();
                    this.fTabGroupExtensions.put(typeId, map);
                }
                if ((modes = group.getModes()).isEmpty()) {
                    map.put("*", group);
                }
                Iterator iter = modes.iterator();
                while (iter.hasNext()) {
                    map.put((String)iter.next(), group);
                }
                ++i;
            }
        }
    }

    private void initializeContributedTabExtensions() {
        this.fContributedTabs = new Hashtable();
        IExtensionPoint epoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "launchConfigurationTabs");
        IConfigurationElement[] elements = epoint.getConfigurationElements();
        LaunchConfigurationTabExtension tab = null;
        Hashtable<String, LaunchConfigurationTabExtension> element = null;
        int i = 0;
        while (i < elements.length) {
            tab = new LaunchConfigurationTabExtension(elements[i]);
            element = (Hashtable<String, LaunchConfigurationTabExtension>)this.fContributedTabs.get(tab.getTabGroupId());
            if (element == null) {
                element = new Hashtable<String, LaunchConfigurationTabExtension>();
                element.put(tab.getIdentifier(), tab);
                this.fContributedTabs.put(tab.getTabGroupId(), element);
            }
            element.put(tab.getIdentifier(), tab);
            ++i;
        }
    }

    public ILaunchConfigurationTabGroup getTabGroup(ILaunchConfigurationType type, String mode) throws CoreException {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        LaunchConfigurationTabGroupExtension ext = this.getExtension(type.getIdentifier(), modes);
        if (ext == null) {
            Status status = new Status(4, "org.eclipse.debug.ui", 120, "No tab group defined for launch configuration type " + type.getIdentifier(), null);
            throw new CoreException((IStatus)status);
        }
        return new LaunchConfigurationTabGroupWrapper(ext.newTabGroup(), ext.getIdentifier(), null);
    }

    public ILaunchConfigurationTabGroup getTabGroup(ILaunchConfiguration config, String mode) throws CoreException {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        LaunchConfigurationTabGroupExtension ext = this.getExtension(config.getType().getIdentifier(), modes);
        if (ext == null) {
            Status status = new Status(4, "org.eclipse.debug.ui", 120, "No tab group defined for launch configuration type " + config.getType().getIdentifier(), null);
            throw new CoreException((IStatus)status);
        }
        return new LaunchConfigurationTabGroupWrapper(ext.newTabGroup(), ext.getIdentifier(), config);
    }

    protected LaunchConfigurationTabExtension[] getTabExtensions(String groupid, ILaunchConfiguration config, String mode) throws CoreException {
        this.initializeContributedTabExtensions();
        Hashtable tabs = (Hashtable)this.fContributedTabs.get(groupid);
        if (tabs != null) {
            return this.filterLaunchTabExtensions(tabs.values().toArray(new LaunchConfigurationTabExtension[tabs.size()]), config, mode);
        }
        return new LaunchConfigurationTabExtension[0];
    }

    protected LaunchConfigurationTabExtension[] filterLaunchTabExtensions(LaunchConfigurationTabExtension[] tabs, ILaunchConfiguration config, String mode) throws CoreException {
        IWorkbenchActivitySupport as = PlatformUI.getWorkbench().getActivitySupport();
        if (as == null || config == null) {
            return tabs;
        }
        HashSet<LaunchConfigurationTabExtension> set = new HashSet<LaunchConfigurationTabExtension>();
        int i = 0;
        while (i < tabs.length) {
            if (!WorkbenchActivityHelper.filterItem((Object)new LaunchTabContribution(tabs[i]))) {
                HashSet modes = (HashSet)config.getModes();
                modes.add(mode);
                ILaunchDelegate delegate = config.getPreferredDelegate((Set)modes);
                if (delegate == null) {
                    delegate = config.getType().getPreferredDelegate((Set)modes);
                }
                Set delegateSet = tabs[i].getDelegateSet();
                if (delegate != null) {
                    if (delegateSet.isEmpty() || delegateSet.contains(delegate.getId())) {
                        set.add(tabs[i]);
                    }
                } else {
                    ILaunchDelegate[] delegates = config.getType().getDelegates((Set)modes);
                    int j = 0;
                    while (j < delegates.length) {
                        if (delegateSet.size() == 0 || delegateSet.contains(delegates[j].getId())) {
                            set.add(tabs[i]);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return set.toArray(new LaunchConfigurationTabExtension[set.size()]);
    }

    protected LaunchConfigurationTabGroupExtension getExtension(String type, Set modes) {
        this.initializeTabGroupExtensions();
        Map map = (Map)this.fTabGroupExtensions.get(type);
        if (map != null) {
            Object extension = map.get(modes);
            if (extension == null) {
                extension = map.get("*");
            }
            return (LaunchConfigurationTabGroupExtension)extension;
        }
        return null;
    }

    public String getHelpContext(ILaunchConfigurationType type, String mode) throws CoreException {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        LaunchConfigurationTabGroupExtension ext = this.getExtension(type.getIdentifier(), modes);
        if (ext == null) {
            Status status = new Status(4, "org.eclipse.debug.ui", 120, "No tab group defined for launch configuration type " + type.getIdentifier(), null);
            throw new CoreException((IStatus)status);
        }
        return ext.getHelpContextId();
    }

    public String getDescription(ILaunchConfigurationType configType, String mode) {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        LaunchConfigurationTabGroupExtension extension = this.getExtension(configType.getAttribute("id"), modes);
        return extension != null ? extension.getDescription(modes) : null;
    }

    public List getLaunchModeNames(Set modes) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator iterator = modes.iterator();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            ILaunchMode mode = manager.getLaunchMode(id);
            if (mode == null) {
                names.add(id);
                continue;
            }
            names.add(DebugUIPlugin.removeAccelerators(mode.getLabel()));
        }
        Collections.sort(names);
        return names;
    }

    public String getLaunchModeLabel(String modeid) {
        String mode = null;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchMode lmode = manager.getLaunchMode(modeid);
        if (lmode != null) {
            return lmode.getLabel();
        }
        return mode;
    }
}

