/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.debug.internal.ui.views.breakpoints.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.views.breakpoints.OtherBreakpointCategory;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegate;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BreakpointsContentProvider
implements ITreeContentProvider,
IPropertyChangeListener {
    private IBreakpointOrganizer[] fOrganizers = null;
    private BreakpointsViewer fViewer;
    private Object[] fElements;
    private boolean fDisposed = false;

    public Object[] getChildren(Object parentElement) {
        if (parentElement.equals(DebugPlugin.getDefault().getBreakpointManager())) {
            return this.fElements;
        }
        if (parentElement instanceof BreakpointContainer) {
            return ((BreakpointContainer)((Object)parentElement)).getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fDisposed = true;
        this.fElements = null;
        this.setOrganizers(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (BreakpointsViewer)viewer;
        if (newInput != null) {
            this.reorganize();
        }
    }

    public void setOrganizers(IBreakpointOrganizer[] organizers) {
        int i;
        if (organizers != null && organizers.length == 0) {
            organizers = null;
        }
        if (this.fOrganizers != null) {
            i = 0;
            while (i < this.fOrganizers.length) {
                this.fOrganizers[i].removePropertyChangeListener(this);
                ++i;
            }
        }
        this.fOrganizers = organizers;
        if (this.fOrganizers != null) {
            i = 0;
            while (i < this.fOrganizers.length) {
                this.fOrganizers[i].addPropertyChangeListener(this);
                ++i;
            }
        }
        if (!this.fDisposed) {
            this.fViewer.getControl().setRedraw(false);
            IBreakpoint[] breakpoints = null;
            if (this.isShowingGroups()) {
                breakpoints = this.fViewer.getVisibleBreakpoints();
            }
            this.reorganize();
            if (this.isShowingGroups()) {
                int i2 = 0;
                while (i2 < this.fElements.length) {
                    BreakpointContainer container = (BreakpointContainer)((Object)this.fElements[i2]);
                    int j = 0;
                    while (j < breakpoints.length) {
                        if (container.contains(breakpoints[j])) {
                            this.fViewer.expandToLevel((Object)container, -1);
                            this.fViewer.updateCheckedState((Object)container);
                            break;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public BreakpointContainer[] getRoots(IBreakpoint breakpoint) {
        if (this.isShowingGroups()) {
            ArrayList<BreakpointContainer> list = new ArrayList<BreakpointContainer>();
            int i = 0;
            while (i < this.fElements.length) {
                BreakpointContainer container = (BreakpointContainer)((Object)this.fElements[i]);
                if (container.contains(breakpoint)) {
                    list.add(container);
                }
                ++i;
            }
            return list.toArray(new BreakpointContainer[list.size()]);
        }
        return null;
    }

    IBreakpointOrganizer[] getOrganizers() {
        return this.fOrganizers;
    }

    protected void reorganize() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        if (this.fOrganizers == null) {
            this.fElements = breakpoints;
        } else {
            IBreakpointOrganizer organizer = this.fOrganizers[0];
            HashMap<IAdaptable, BreakpointContainer> categoriesToContainers = new HashMap<IAdaptable, BreakpointContainer>();
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                IAdaptable[] categories = organizer.getCategories(breakpoint);
                if (categories == null || categories.length == 0) {
                    categories = OtherBreakpointCategory.getCategories(organizer);
                }
                int j = 0;
                while (j < categories.length) {
                    IAdaptable category = categories[j];
                    BreakpointContainer container = (BreakpointContainer)((Object)categoriesToContainers.get(category));
                    if (container == null) {
                        IBreakpointOrganizer[] nesting = null;
                        if (this.fOrganizers.length > 1) {
                            nesting = new IBreakpointOrganizer[this.fOrganizers.length - 1];
                            System.arraycopy(this.fOrganizers, 1, nesting, 0, nesting.length);
                        }
                        container = new BreakpointContainer(category, organizer, nesting);
                        categoriesToContainers.put(category, container);
                    }
                    container.addBreakpoint(breakpoint);
                    ++j;
                }
                ++i;
            }
            IAdaptable[] emptyCategories = organizer.getCategories();
            if (emptyCategories != null) {
                int i2 = 0;
                while (i2 < emptyCategories.length) {
                    IAdaptable category = emptyCategories[i2];
                    BreakpointContainer container = (BreakpointContainer)((Object)categoriesToContainers.get(category));
                    if (container == null) {
                        container = new BreakpointContainer(category, organizer, null);
                        categoriesToContainers.put(category, container);
                    }
                    ++i2;
                }
            }
            this.fElements = categoriesToContainers.values().toArray();
        }
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IBreakpointOrganizerDelegate.P_CATEGORY_CHANGED)) {
            this.reorganize();
        }
    }

    protected BreakpointContainer[] getContainers(IBreakpoint breakpoint) {
        if (this.isShowingGroups()) {
            IAdaptable[] categories = this.fOrganizers[0].getCategories(breakpoint);
            if (categories == null || categories.length == 0) {
                categories = OtherBreakpointCategory.getCategories(this.fOrganizers[0]);
            }
            BreakpointContainer[] containers = new BreakpointContainer[categories.length];
            int index = 0;
            int i = 0;
            while (i < this.fElements.length) {
                BreakpointContainer container = (BreakpointContainer)((Object)this.fElements[i]);
                int j = 0;
                while (j < categories.length) {
                    IAdaptable category = categories[j];
                    if (container.getCategory().equals(category)) {
                        containers[index] = container;
                        ++index;
                    }
                    ++j;
                }
                ++i;
            }
            return containers;
        }
        return null;
    }

    protected boolean isShowingGroups() {
        return this.fOrganizers != null;
    }
}

