/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class RunToLineActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IWorkbenchPart fActivePart = null;
    private IRunToLineTarget fPartTarget = null;
    private IAction fAction = null;
    private DebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fActivePart.getSite().getWorkbenchWindow()).removeDebugContextListener(this.fContextListener);
        this.fActivePart = null;
        this.fPartTarget = null;
    }

    public void run(IAction action) {
        if (this.fPartTarget != null && this.fTargetElement != null) {
            try {
                this.fPartTarget.runToLine(this.fActivePart, this.fActivePart.getSite().getSelectionProvider().getSelection(), this.fTargetElement);
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.fActivePart.getSite().getWorkbenchWindow().getShell(), ActionMessages.RunToLineAction_0, ActionMessages.RunToLineAction_1, e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.update();
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                ISelectionProvider selectionProvider;
                IWorkbenchPartSite site;
                boolean enabled = false;
                if (RunToLineActionDelegate.this.fPartTarget != null && RunToLineActionDelegate.this.fTargetElement != null && (site = RunToLineActionDelegate.this.fActivePart.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null) {
                    ISelection selection = selectionProvider.getSelection();
                    enabled = RunToLineActionDelegate.this.fTargetElement.isSuspended() && RunToLineActionDelegate.this.fPartTarget.canRunToLine(RunToLineActionDelegate.this.fActivePart, selection, RunToLineActionDelegate.this.fTargetElement);
                }
                RunToLineActionDelegate.this.fAction.setEnabled(enabled);
            }
        };
        DebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void init(IAction action) {
        this.fAction = action;
        if (action != null) {
            action.setText(ActionMessages.RunToLineActionDelegate_4);
            action.setImageDescriptor(DebugUITools.getImageDescriptor("IMG_LCL_RUN_TO_LINE"));
            action.setDisabledImageDescriptor(DebugUITools.getImageDescriptor("IMG_DLCL_RUN_TO_LINE"));
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.init(action);
        this.bindTo((IWorkbenchPart)targetEditor);
    }

    public void init(IViewPart view) {
        this.bindTo((IWorkbenchPart)view);
    }

    private void bindTo(IWorkbenchPart part) {
        IDebugContextManager manager = DebugUITools.getDebugContextManager();
        if (this.fActivePart != null && !this.fActivePart.equals(part)) {
            manager.getContextService(this.fActivePart.getSite().getWorkbenchWindow()).removeDebugContextListener(this.fContextListener);
        }
        this.fPartTarget = null;
        this.fActivePart = part;
        if (part != null) {
            IWorkbenchWindow workbenchWindow = part.getSite().getWorkbenchWindow();
            IDebugContextService service = manager.getContextService(workbenchWindow);
            service.addDebugContextListener(this.fContextListener);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fPartTarget = (IRunToLineTarget)part.getAdapter((Class)clazz);
            if (this.fPartTarget == null) {
                IAdapterManager adapterManager = Platform.getAdapterManager();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterManager.hasAdapter((Object)part, clazz2.getName())) {
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.fPartTarget = (IRunToLineTarget)adapterManager.loadAdapter((Object)part, clazz3.getName());
                }
            }
            ISelection activeContext = service.getActiveContext();
            this.fContextListener.contextActivated(activeContext);
        }
        this.update();
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        protected void contextActivated(ISelection selection) {
            IStructuredSelection ss;
            RunToLineActionDelegate.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                Object object = ss.getFirstElement();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.core.model.ISuspendResume");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                RunToLineActionDelegate.this.fTargetElement = (ISuspendResume)DebugPlugin.getAdapter((Object)object, (Class)clazz);
            }
            RunToLineActionDelegate.this.update();
        }

        public void debugContextChanged(DebugContextEvent event) {
            this.contextActivated(event.getContext());
        }
    }
}

