/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.ParameterizedProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;

public class DebugHelper {
    public static final String LINE_SEPARATOR;
    public static final boolean DEBUG_PROFILE_REGISTRY;
    public static final boolean DEBUG_ENGINE;
    public static final boolean DEBUG_ENGINE_SESSION;
    static /* synthetic */ Class class$0;

    static {
        DebugOptions options;
        LINE_SEPARATOR = System.getProperty("line.separator");
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((options = (DebugOptions)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            DEBUG_PROFILE_REGISTRY = options.getBooleanOption("org.eclipse.equinox.p2.engine/profileregistry/debug", false);
            DEBUG_ENGINE = options.getBooleanOption("org.eclipse.equinox.p2.engine/engine/debug", false);
            DEBUG_ENGINE_SESSION = options.getBooleanOption("org.eclipse.equinox.p2.engine/enginesession/debug", false);
        } else {
            DEBUG_PROFILE_REGISTRY = false;
            DEBUG_ENGINE = false;
            DEBUG_ENGINE_SESSION = false;
        }
    }

    public static void debug(String name, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append("org.eclipse.equinox.p2.engine-" + name);
        buffer.append("] ");
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] " + LINE_SEPARATOR);
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    public static String formatArray(Object[] array, boolean toString, boolean newLines) {
        if (array == null || array.length == 0) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        int i = 0;
        while (true) {
            if (toString) {
                buffer.append(array[i].toString());
            } else {
                buffer.append(array[i].getClass().getName());
            }
            if (++i == array.length) break;
            buffer.append(',');
            if (newLines) {
                buffer.append(LINE_SEPARATOR);
                continue;
            }
            buffer.append(' ');
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static String formatOperation(PhaseSet phaseSet, Operand[] operands, ProvisioningContext context) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("phaseSet=" + DebugHelper.formatPhaseSet(phaseSet));
        buffer.append(",");
        buffer.append(LINE_SEPARATOR);
        buffer.append("operands=" + DebugHelper.formatOperands(operands));
        buffer.append(",");
        buffer.append(LINE_SEPARATOR);
        buffer.append("context=" + DebugHelper.formatContext(context));
        return buffer.toString();
    }

    public static String formatOperands(Operand[] operands) {
        Object[] operandStrings = new String[operands.length];
        int i = 0;
        while (i < operands.length) {
            if (operands[i] instanceof InstallableUnitOperand) {
                InstallableUnitOperand iuOperand = (InstallableUnitOperand)operands[i];
                operandStrings[i] = DebugHelper.formatInstallableUnitOperand(iuOperand);
            } else {
                operandStrings[i] = operands[i].toString();
            }
            ++i;
        }
        return DebugHelper.formatArray(operandStrings, true, true);
    }

    public static String formatInstallableUnitOperand(InstallableUnitOperand iuOperand) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(iuOperand.first());
        if (iuOperand.first() != null && iuOperand.first().getFragments() != null) {
            buffer.append(DebugHelper.formatArray(iuOperand.first().getFragments(), true, false));
        }
        buffer.append(" --> ");
        buffer.append(iuOperand.second());
        if (iuOperand.second() != null && iuOperand.second().getFragments() != null) {
            buffer.append(DebugHelper.formatArray(iuOperand.second().getFragments(), true, false));
        }
        return buffer.toString();
    }

    public static String formatPhaseSet(PhaseSet phaseSet) {
        StringBuffer buffer = new StringBuffer(phaseSet.getClass().getName());
        buffer.append(DebugHelper.formatArray(phaseSet.getPhases(), false, false));
        return buffer.toString();
    }

    public static String formatContext(ProvisioningContext context) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{artifactRepos=" + DebugHelper.formatArray(context.getArtifactRepositories(), true, false));
        buffer.append(", metadataRepos=" + DebugHelper.formatArray(context.getMetadataRepositories(), true, false));
        buffer.append(", properties=" + context.getProperties() + "}");
        return buffer.toString();
    }

    public static String formatAction(ProvisioningAction action, Map parameters) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(action.getClass().getName());
        if (action instanceof ParameterizedProvisioningAction) {
            ParameterizedProvisioningAction parameterizedAction = (ParameterizedProvisioningAction)action;
            buffer.append("{action=" + parameterizedAction.getAction().getClass().getName());
            buffer.append(", actionText=" + parameterizedAction.getActionText() + "}");
        }
        buffer.append(LINE_SEPARATOR);
        buffer.append("parameters=" + DebugHelper.formatParameters(parameters));
        return buffer.toString();
    }

    public static String formatParameters(Map parameters) {
        Iterator it = parameters.entrySet().iterator();
        if (!it.hasNext()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        while (true) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            buffer.append(key);
            buffer.append('=');
            Object value = e.getValue();
            if (value instanceof String || value instanceof File || value instanceof Operand || value instanceof IArtifactKey || value instanceof IInstallableUnit) {
                buffer.append(value);
            } else if (value instanceof IProfile) {
                buffer.append(((IProfile)value).getProfileId());
            } else {
                buffer.append(value.getClass().getName());
            }
            if (!it.hasNext()) break;
            buffer.append(',');
            buffer.append(LINE_SEPARATOR);
            buffer.append(' ');
        }
        buffer.append('}');
        return buffer.toString();
    }
}

