/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine.phases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.engine.CertificateChecker;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;

public class CheckTrust
extends InstallableUnitPhase {
    private static final String PHASE_ID = "checkTrust";
    public static final String PARM_ARTIFACT_FILES = "artifactFiles";

    public CheckTrust(int weight) {
        super(PHASE_ID, weight);
    }

    protected boolean isApplicable(InstallableUnitOperand op) {
        return op.second() != null;
    }

    protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        Collection artifactRequests = (Collection)parameters.get(PARM_ARTIFACT_FILES);
        CertificateChecker certificateChecker = new CertificateChecker();
        certificateChecker.add(artifactRequests.toArray());
        IStatus status = certificateChecker.start();
        return status;
    }

    protected ProvisioningAction[] getActions(InstallableUnitOperand operand) {
        IInstallableUnit unit = operand.second();
        ProvisioningAction[] parsedActions = this.getActions(unit, this.phaseId);
        if (parsedActions != null) {
            return parsedActions;
        }
        ITouchpointType type = unit.getTouchpointType();
        if (type == null || type == ITouchpointType.NONE) {
            return null;
        }
        String actionId = this.getActionManager().getTouchpointQualifiedActionId(this.phaseId, type);
        ProvisioningAction action = this.getActionManager().getAction(actionId, null);
        if (action == null) {
            return null;
        }
        return new ProvisioningAction[]{action};
    }

    protected IStatus initializeOperand(IProfile profile, InstallableUnitOperand operand, Map parameters, IProgressMonitor monitor) {
        IInstallableUnit iu = operand.second();
        parameters.put("iu", iu);
        return super.initializeOperand(profile, operand, parameters, monitor);
    }

    protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        parameters.put(PARM_ARTIFACT_FILES, new ArrayList());
        return super.initializePhase(monitor, profile, parameters);
    }
}

