/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenWithMenu
extends ContributionItem {
    private IStructuredSelection selection;
    private HistoryPage page;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final int MATCH_BOTH = 3;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public OpenWithMenu(HistoryPage page) {
        super(ID);
        this.page = page;
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getFileRevision().getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(this.getFileRevision().getName());
        }
        return imageDesc;
    }

    private MenuItem createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openEditor(descriptor, false);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
        return menuItem;
    }

    private void createOtherMenuItem(final Menu menu) {
        final IFileRevision fileResource = this.getFileRevision();
        if (fileResource == null) {
            return;
        }
        new MenuItem(menu, 2);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(TeamUIMessages.LocalHistoryPage_OpenWithMenu_Other);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        IEditorDescriptor editor;
                        EditorSelectionDialog dialog = new EditorSelectionDialog(menu.getShell());
                        dialog.setMessage(NLS.bind((String)TeamUIMessages.LocalHistoryPage_OpenWithMenu_OtherDialogDescription, (Object)fileResource.getName()));
                        if (dialog.open() != 0 || (editor = dialog.getSelectedEditor()) == null) break;
                        OpenWithMenu.this.openEditor(editor, editor.isOpenExternal());
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IFileRevision fileRevision = this.getFileRevision();
        if (fileRevision == null) {
            return;
        }
        IEditorDescriptor defaultTextEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor preferredEditor = Utils.getDefaultEditor(fileRevision);
        IEditorDescriptor[] editors = Utils.getEditors(fileRevision);
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultTextEditor != null && editor.getId().equals(defaultTextEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultTextEditor != null) {
            this.createMenuItem(menu, defaultTextEditor, preferredEditor);
        }
        this.createDefaultMenuItem(menu, fileRevision);
        this.createOtherMenuItem(menu);
    }

    public void createDefaultMenuItem(Menu menu, final IFileRevision revision) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(Utils.getDefaultEditor(revision) == null);
        menuItem.setText(TeamUIMessages.LocalHistoryPage_OpenWithMenu_DefaultEditorDescription);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openEditor(Utils.getDefaultEditor(revision), false);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
        IFileRevision fileRevision = this.getFileRevision();
        if (fileRevision == null) {
            return;
        }
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IStorage storage = fileRevision.getStorage((IProgressMonitor)monitor);
            boolean isFile = storage instanceof IFile;
            if (openUsingDescriptor) {
                ((WorkbenchPage)this.page.getSite().getPage()).openEditorFromDescriptor((IEditorInput)(isFile ? new FileEditorInput((IFile)storage) : FileRevisionEditorInput.createEditorInputFor(fileRevision, (IProgressMonitor)monitor)), editorDescriptor, true, null);
            } else {
                String editorId = editorDescriptor == null ? "org.eclipse.ui.systemExternalEditor" : editorDescriptor.getId();
                this.page.getSite().getPage().openEditor((IEditorInput)(isFile ? new FileEditorInput((IFile)storage) : FileRevisionEditorInput.createEditorInputFor(fileRevision, (IProgressMonitor)monitor)), editorId, true, 3);
            }
        }
        catch (PartInitException e) {
            StatusAdapter statusAdapter = new StatusAdapter(e.getStatus());
            statusAdapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)TeamUIMessages.LocalHistoryPage_OpenEditorError);
            StatusManager.getManager().handle(statusAdapter, 2);
        }
        catch (CoreException e) {
            StatusAdapter statusAdapter = new StatusAdapter(e.getStatus());
            statusAdapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)TeamUIMessages.LocalHistoryPage_OpenEditorError);
            StatusManager.getManager().handle(statusAdapter, 1);
        }
    }

    private IFileRevision getFileRevision() {
        IStructuredSelection structSel = this.selection;
        IFileRevision revision = null;
        if (structSel == null) {
            return null;
        }
        Object[] objArray = structSel.toArray();
        int i = 0;
        while (i < objArray.length) {
            Object tempRevision = objArray[i];
            if (!(tempRevision instanceof AbstractHistoryCategory)) {
                revision = (IFileRevision)tempRevision;
            }
            ++i;
        }
        return revision;
    }

    public boolean isDynamic() {
        return true;
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selection = selection instanceof IStructuredSelection ? selection : StructuredSelection.EMPTY;
    }
}

