/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.ImportProjectSetMainPage;
import org.eclipse.team.internal.ui.wizards.ImportProjectSetOperation;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.xml.sax.SAXException;

public class ProjectSetImportWizard
extends Wizard
implements IImportWizard {
    ImportProjectSetMainPage mainPage;

    public ProjectSetImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TeamUIMessages.ProjectSetImportWizard_Project_Set_1);
    }

    public void addPages() {
        this.mainPage = new ImportProjectSetMainPage("projectSetMainPage", TeamUIMessages.ProjectSetImportWizard_Import_a_Project_Set_3, TeamUIPlugin.getImageDescriptor("wizban/import_projectset_wizban.png"));
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        boolean[] result = new boolean[1];
        try {
            ImportProjectSetOperation op = new ImportProjectSetOperation((IRunnableContext)(this.mainPage.isRunInBackgroundOn() ? null : this.getContainer()), this.mainPage.getFileName(), this.mainPage.getWorkingSets());
            op.run();
            result[0] = true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof TeamException) {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                return false;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            if (target instanceof SAXException) {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)new Status(4, "org.eclipse.team.ui", 0, NLS.bind((String)TeamUIMessages.ProjectSetImportWizard_2, (Object[])new String[]{target.getMessage()}), target));
                return false;
            }
            ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)new Status(4, "org.eclipse.team.ui", 0, NLS.bind((String)TeamUIMessages.ProjectSetImportWizard_3, (Object[])new String[]{target.getMessage()}), target));
        }
        return result[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        PsfFilenameStore.setDefaultFromSelection(workbench);
    }
}

