/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.ui.filters;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

import org.eclipse.jdt.core.IClassFile;

public class InnerClassFilesFilter extends ViewerFilter {

	public InnerClassFilesFilter() {
	}

	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (element instanceof IClassFile) {
			IClassFile classFile= (IClassFile) element;
			return classFile.getElementName().indexOf('$') == -1;
		}
		return true;
	}

}
