/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.internal.commons.core.ErrorReporterManager;

public class StatusHandler {
    private static ErrorReporterManager errorReporterManager;

    public static void log(IStatus status) {
        ILog log;
        if (InternalPlatform.getDefault() != null && PlatformActivator.getContext() != null && (log = InternalPlatform.getDefault().getLog(PlatformActivator.getContext().getBundle())) != null) {
            log.log(status);
        }
        if (CoreUtil.TEST_MODE) {
            StatusHandler.dumpErrorToConsole(status);
        }
    }

    public static void fail(IStatus status) {
        StatusHandler.log(status);
        StatusHandler.getErrorReporterManager().fail(status);
    }

    private static synchronized ErrorReporterManager getErrorReporterManager() {
        if (errorReporterManager == null) {
            errorReporterManager = new ErrorReporterManager();
        }
        return errorReporterManager;
    }

    private static void dumpErrorToConsole(IStatus status) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Calendar now = Calendar.getInstance();
        sb.append(DateUtil.getIsoFormattedDateTime(now));
        sb.append("] ");
        sb.append(String.valueOf(status.toString()) + ", ");
        if (status.getException() != null) {
            sb.append("Exception:\n");
            sb.append(StatusHandler.printStrackTrace(status.getException()));
        }
        System.err.println(sb.toString());
    }

    private static String printStrackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

