/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointSelectionAction;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Item;

public class RemoveFromWorkingSetAction
extends BreakpointSelectionAction {
    public RemoveFromWorkingSetAction(BreakpointsView view) {
        super(BreakpointGroupMessages.RemoveFromWorkingSetAction_0, view);
    }

    public void run() {
        BreakpointsViewer viewer = (BreakpointsViewer)this.getBreakpointsView().getViewer();
        Item[] items = viewer.getSelectedItems();
        IBreakpoint breakpoint = null;
        BreakpointContainer container = null;
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof IBreakpoint) {
                breakpoint = (IBreakpoint)items[i].getData();
                container = viewer.getRemovableContainer(items[i]);
                if (container != null) {
                    container.getOrganizer().removeBreakpoint(breakpoint, container.getCategory());
                }
            }
            ++i;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof BreakpointContainer) {
            return ((BreakpointContainer)((Object)element)).getCategory().equals("org.eclipse.debug.ui.breakpointWorkingSet");
        }
        return false;
    }
}

