/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.debug.internal.ui.viewers.model.VirtualTree;

class VirtualItem {
    static String LABEL_KEY = "LABEL_KEY";
    static String IMAGE_KEY = "IMAGE_KEY";
    static String FONT_KEY = "FONT_KEY";
    static String FOREGROUND_KEY = "FOREGROUND_KEY";
    static String BACKGROUND_KEY = "BACKGROUND_KEY";
    static String ELEMENT_DATA_KEY = "element";
    private final VirtualItem fParent;
    private final Index fIndex;
    private Map fItems = new TreeMap();
    private boolean fHasItems = false;
    private boolean fExpanded = false;
    private int fItemCount = -1;
    private Map fData = new HashMap(1);
    private boolean fNeedsLabelUpdate = true;
    private boolean fNeedsCountUpdate = true;
    private boolean fNeedsDataUpdate = true;
    private boolean fDisposed = false;

    VirtualItem(VirtualItem parent, Index index) {
        this.fParent = parent;
        this.fIndex = index;
    }

    void setNeedsCountUpdate() {
        this.fNeedsCountUpdate = true;
        this.fItemCount = -1;
    }

    void setNeedsLabelUpdate() {
        this.fNeedsLabelUpdate = true;
    }

    void setNeedsDataUpdate() {
        this.fNeedsDataUpdate = true;
    }

    void clear(Index index) {
        VirtualItem item = (VirtualItem)this.fItems.remove(index);
        if (item != null) {
            item.dispose();
        }
    }

    VirtualItem getParent() {
        return this.fParent;
    }

    Index getIndex() {
        return this.fIndex;
    }

    VirtualItem findItem(Object element) {
        Iterator itr = this.fItems.values().iterator();
        while (itr.hasNext()) {
            VirtualItem next = (VirtualItem)itr.next();
            Object nextData = next.getData();
            if ((element == null || !element.equals(nextData)) && (element != null || nextData != null)) continue;
            return next;
        }
        return null;
    }

    boolean needsDataUpdate() {
        return this.fNeedsDataUpdate;
    }

    void clearNeedsDataUpdate() {
        this.fNeedsDataUpdate = false;
    }

    boolean needsCountUpdate() {
        return this.fNeedsCountUpdate;
    }

    void clearNeedsCountUpdate() {
        this.fNeedsCountUpdate = false;
    }

    boolean needsLabelUpdate() {
        return this.fNeedsLabelUpdate;
    }

    void clearNeedsLabelUpdate() {
        this.fNeedsLabelUpdate = false;
    }

    boolean isDisposed() {
        return this.fDisposed;
    }

    void dispose() {
        this.fData.clear();
        Iterator itr = this.fItems.values().iterator();
        while (itr.hasNext()) {
            ((VirtualItem)itr.next()).dispose();
        }
        this.fItems.clear();
        this.fDisposed = true;
        this.findTree().fireItemDisposed(this);
    }

    Object getData(String key) {
        return this.fData.get(key);
    }

    void setData(String key, Object data) {
        this.fData.put(key, data);
    }

    void setData(Object data) {
        this.fData.put(ELEMENT_DATA_KEY, data);
        if (data == null) {
            this.fNeedsDataUpdate = true;
        }
    }

    Object getData() {
        return this.fData.get(ELEMENT_DATA_KEY);
    }

    void setExpanded(boolean expanded) {
        this.fExpanded = expanded;
        if (!this.fExpanded) {
            Iterator itr = this.fItems.values().iterator();
            while (itr.hasNext()) {
                ((VirtualItem)itr.next()).setExpanded(expanded);
            }
        }
    }

    boolean getExpanded() {
        return this.fExpanded;
    }

    void setHasItems(boolean hasChildren) {
        this.fHasItems = hasChildren;
        if (!this.fHasItems) {
            if (this.getItemCount() != 0) {
                this.setItemCount(0);
            }
        } else if (this.getItemCount() == 0) {
            this.setItemCount(-1);
        }
    }

    boolean hasItems() {
        return this.fHasItems;
    }

    void setItemCount(int count) {
        this.fItemCount = count;
        Iterator itr = this.fItems.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            int index = ((Index)entry.getKey()).intValue();
            if (index < count) continue;
            itr.remove();
            VirtualItem item = (VirtualItem)entry.getValue();
            item.dispose();
        }
        if (this.fItemCount == 0) {
            if (this.hasItems()) {
                this.setHasItems(false);
            }
            if (this.getExpanded()) {
                this.setExpanded(false);
            }
        } else if (!this.hasItems()) {
            this.setHasItems(true);
        }
    }

    int getItemCount() {
        return this.fItemCount;
    }

    VirtualItem getItem(Index index) {
        this.ensureItems();
        VirtualItem item = (VirtualItem)this.fItems.get(index);
        if (item == null) {
            item = new VirtualItem(this, index);
            this.fItems.put(index, item);
        }
        return item;
    }

    VirtualItem[] getItems() {
        return this.fItems.values().toArray(new VirtualItem[this.fItems.size()]);
    }

    VirtualItem addItem(int position) {
        if (!this.fHasItems) {
            this.fHasItems = true;
        }
        if (this.fItemCount < 0) {
            this.fItemCount = 0;
        }
        ++this.fItemCount;
        this.ensureItems();
        Iterator itr = this.fItems.keySet().iterator();
        while (itr.hasNext()) {
            Index childIndex = (Index)itr.next();
            if (childIndex.intValue() < position) continue;
            childIndex.increment();
        }
        Index childIndex = new Index(position);
        VirtualItem newChild = new VirtualItem(this, childIndex);
        this.fItems.put(childIndex, newChild);
        return newChild;
    }

    void remove(Index position) {
        --this.fItemCount;
        if (this.fItemCount < 0) {
            this.fHasItems = false;
        }
        this.ensureItems();
        VirtualItem removedItem = null;
        Iterator itr = this.fItems.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Index childIndex = (Index)entry.getKey();
            if (childIndex.intValue() > position.intValue()) {
                childIndex.decrement();
                continue;
            }
            if (childIndex.intValue() != position.intValue()) continue;
            removedItem = (VirtualItem)entry.getValue();
            removedItem.dispose();
            itr.remove();
        }
    }

    private void ensureItems() {
        if (this.fItems == null) {
            this.fItems = new HashMap(Math.max(1, Math.min(this.fItemCount, 16)));
        }
    }

    private VirtualTree findTree() {
        VirtualItem item = this;
        while (!(item instanceof VirtualTree)) {
            item = item.fParent;
        }
        return (VirtualTree)item;
    }

    public String toString() {
        String[] label = (String[])this.fData.get(LABEL_KEY);
        if (label != null && label.length != 0) {
            return label[0];
        }
        Object data = this.fData.get(ELEMENT_DATA_KEY);
        if (data != null) {
            return data.toString();
        }
        return super.toString();
    }

    public static class Index
    implements Comparable {
        private Integer fIndexValue;

        public Index(int index) {
            this.fIndexValue = new Integer(index);
        }

        public boolean equals(Object obj) {
            return obj instanceof Index && ((Index)obj).fIndexValue.equals(this.fIndexValue);
        }

        public int hashCode() {
            return this.fIndexValue.hashCode();
        }

        public void increment() {
            this.fIndexValue = new Integer(this.fIndexValue + 1);
        }

        public void decrement() {
            this.fIndexValue = new Integer(this.fIndexValue - 1);
        }

        public int intValue() {
            return this.fIndexValue;
        }

        public int compareTo(Object obj) {
            return obj instanceof Index ? ((Index)obj).fIndexValue.compareTo(this.fIndexValue) : 0;
        }

        public String toString() {
            return this.fIndexValue.toString();
        }
    }
}

