/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class BreakpointsDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private BreakpointsViewer fViewer;
    private Item[] fItems = null;

    public BreakpointsDragAdapter(BreakpointsViewer viewer) {
        Assert.isNotNull((Object)((Object)viewer));
        this.fViewer = viewer;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fViewer.getSelection();
        LocalSelectionTransfer.getInstance().setSelection(selection);
        LocalSelectionTransfer.getInstance().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
        event.doit = this.fViewer.canDrag(this.fViewer.getSelectedItems());
        this.fItems = this.fViewer.getSelectedItems();
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = LocalSelectionTransfer.getInstance().getSelection();
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 2) {
            this.fViewer.performDrag(this.fItems);
        }
        this.fItems = null;
        LocalSelectionTransfer.getInstance().setSelection(null);
        LocalSelectionTransfer.getInstance().setSelectionSetTime(0L);
    }
}

