/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.EmptyElementExplanation;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.ui.ElementWrapper;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.osgi.util.NLS;

public abstract class QueriedElementWrapper
extends ElementWrapper {
    protected IQueryable queryable;
    protected Object parent;
    protected String emptyExplanationString;
    protected int emptyExplanationSeverity;
    protected String emptyExplanationDescription;

    public QueriedElementWrapper(IQueryable queryable, Object parent) {
        this.queryable = queryable;
        this.parent = parent;
    }

    protected Object wrap(Object item) {
        QueriedElement element;
        if (item instanceof QueriedElement && !(element = (QueriedElement)item).knowsQueryable()) {
            element.setQueryable(this.queryable);
        }
        return item;
    }

    public Collection getElements(Collector collector) {
        this.emptyExplanationString = null;
        this.emptyExplanationSeverity = 1;
        this.emptyExplanationDescription = null;
        if (collector.isEmpty()) {
            MetadataRepositoryElement repo;
            if (this.parent instanceof MetadataRepositoryElement && ProvUI.hasNotFoundStatusBeenReported((repo = (MetadataRepositoryElement)this.parent).getLocation())) {
                String description = null;
                if (Policy.getDefault().getRepositoryManipulator() != null) {
                    description = Policy.getDefault().getRepositoryManipulator().getRepositoryNotFoundInstructionString();
                }
                return this.emptyExplanation(4, NLS.bind((String)ProvUIMessages.QueriedElementWrapper_SiteNotFound, (Object)URIUtil.toUnencodedString((URI)repo.getLocation())), description);
            }
            if (this.parent instanceof QueriedElement) {
                QueriedElement element = (QueriedElement)this.parent;
                IUViewQueryContext context = element.getQueryContext();
                if (context == null) {
                    context = element.getPolicy().getQueryContext();
                }
                if (this.parent instanceof MetadataRepositoryElement || this.parent instanceof MetadataRepositories) {
                    if (context != null && context.getViewType() == 1 && context.getUseCategories()) {
                        return this.emptyExplanation(1, ProvUIMessages.QueriedElementWrapper_NoCategorizedItemsExplanation, context.getUsingCategoriesDescription());
                    }
                    return this.emptyExplanation(1, ProvUIMessages.QueriedElementWrapper_NoItemsExplanation, null);
                }
            }
            return Collections.EMPTY_LIST;
        }
        Collection elements = super.getElements(collector);
        if (elements.isEmpty()) {
            if (this.emptyExplanationString != null) {
                return this.emptyExplanation(this.emptyExplanationSeverity, this.emptyExplanationString, this.emptyExplanationDescription);
            }
            return this.emptyExplanation(this.emptyExplanationSeverity, ProvUIMessages.QueriedElementWrapper_NoItemsExplanation, null);
        }
        return elements;
    }

    Collection emptyExplanation(int severity, String explanationString, String explanationDescription) {
        ArrayList<EmptyElementExplanation> collection = new ArrayList<EmptyElementExplanation>(1);
        collection.add(new EmptyElementExplanation(this.parent, severity, explanationString, explanationDescription));
        return collection;
    }
}

