/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutable;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

@ThreadSafe
public class RequestMonitor
extends DsfExecutable {
    private final Executor fExecutor;
    private final RequestMonitor fParentRequestMonitor;
    private ListenerList fCancelListeners;
    private IStatus fStatus = Status.OK_STATUS;
    private boolean fCanceled = false;
    private boolean fDone = false;

    public RequestMonitor(Executor executor, RequestMonitor parentRequestMonitor) {
        this.fExecutor = executor;
        this.fParentRequestMonitor = parentRequestMonitor;
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.addCancelListener(new ICanceledListener(){

                public void requestCanceled(RequestMonitor rm) {
                    RequestMonitor.this.cancel();
                }
            });
        }
    }

    public synchronized void setStatus(IStatus status) {
        assert (this.isCanceled() || status.getSeverity() != 8);
        this.fStatus = status;
    }

    public synchronized IStatus getStatus() {
        if (this.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return this.fStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object[] listeners = null;
        RequestMonitor requestMonitor = this;
        synchronized (requestMonitor) {
            if (!this.fCanceled) {
                this.fCanceled = true;
                if (this.fCancelListeners != null) {
                    listeners = this.fCancelListeners.getListeners();
                }
            }
        }
        if (listeners != null) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((ICanceledListener)listener).requestCanceled(this);
                ++n2;
            }
        }
    }

    public synchronized boolean isCanceled() {
        return this.fCanceled || this.fParentRequestMonitor != null && this.fParentRequestMonitor.isCanceled();
    }

    public synchronized void addCancelListener(ICanceledListener listener) {
        if (this.fCancelListeners == null) {
            this.fCancelListeners = new ListenerList();
        }
        this.fCancelListeners.add((Object)listener);
    }

    public synchronized void removeCancelListener(ICanceledListener listener) {
        if (this.fCancelListeners != null) {
            this.fCancelListeners.remove((Object)listener);
        }
    }

    public synchronized void done() {
        this.setSubmitted();
        if (this.fDone) {
            throw new IllegalStateException("RequestMonitor: " + this + ", done() method called more than once");
        }
        this.fCancelListeners = null;
        this.fDone = true;
        try {
            this.fExecutor.execute(new DsfRunnable(){

                public void run() {
                    RequestMonitor.this.handleCompleted();
                }

                public String toString() {
                    return "Completed: " + RequestMonitor.this.toString();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.handleRejectedExecutionException();
        }
    }

    public String toString() {
        return "RequestMonitor (" + super.toString() + "): " + this.getStatus().toString();
    }

    public boolean isSuccess() {
        return !this.isCanceled() && this.getStatus().getSeverity() <= 1;
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleCompleted() {
        if (this.isSuccess()) {
            this.handleSuccess();
        } else {
            this.handleFailure();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleSuccess() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.done();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleFailure() {
        assert (!this.isSuccess());
        if (this.isCanceled()) {
            this.handleCancel();
        } else {
            if (this.getStatus().getSeverity() == 8) {
                DsfPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Request monitor: '" + this + "' resulted in a cancel status: " + this.getStatus() + ", even though the request is not set to cancel.", null));
            }
            this.handleErrorOrWarning();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleErrorOrWarning() {
        if (this.getStatus().getSeverity() == 4) {
            this.handleError();
        } else {
            this.handleWarning();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleError() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus(this.getStatus());
            this.fParentRequestMonitor.done();
        } else {
            MultiStatus logStatus = new MultiStatus("org.eclipse.cdt.dsf", 10005, "Request for monitor: '" + this.toString() + "' resulted in an error.", null);
            logStatus.merge(this.getStatus());
            DsfPlugin.getDefault().getLog().log((IStatus)logStatus);
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleWarning() {
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus(this.getStatus());
            this.fParentRequestMonitor.done();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleCancel() {
        if (this.fParentRequestMonitor != null) {
            if (this.getStatus().getSeverity() == 8 && !this.fParentRequestMonitor.isCanceled()) {
                this.fParentRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Sub-request " + this.toString() + " was canceled and not handled.'", null));
            } else {
                this.fParentRequestMonitor.setStatus(this.getStatus());
            }
            this.fParentRequestMonitor.done();
        }
    }

    protected void handleRejectedExecutionException() {
        MultiStatus logStatus = new MultiStatus("org.eclipse.cdt.dsf", 10005, "Request for monitor: '" + this.toString() + "' resulted in a rejected execution exception.", null);
        logStatus.merge(this.getStatus());
        if (this.fParentRequestMonitor != null) {
            this.fParentRequestMonitor.setStatus((IStatus)logStatus);
            this.fParentRequestMonitor.done();
        } else {
            DsfPlugin.getDefault().getLog().log((IStatus)logStatus);
        }
    }

    public static interface ICanceledListener {
        public void requestCanceled(RequestMonitor var1);
    }
}

