/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.mylyn.internal.ui.ActiveFoldingEditorTracker;
import org.eclipse.cdt.mylyn.internal.ui.CDTEditorMonitor;
import org.eclipse.cdt.mylyn.internal.ui.CDTUiUtil;
import org.eclipse.cdt.mylyn.internal.ui.InterestInducingProblemListener;
import org.eclipse.cdt.mylyn.internal.ui.InterestUpdateDeltaListener;
import org.eclipse.cdt.mylyn.internal.ui.LandmarkMarkerManager;
import org.eclipse.cdt.mylyn.internal.ui.editor.ActiveFoldingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CDTUIBridgePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.mylyn.ui";
    public static final String AUTO_FOLDING_ENABLED = "org.eclipse.mylyn.context.ui.editor.folding.enabled";
    private static final String MYLYN_FIRST_RUN = "org.eclipse.mylyn.ui.first.run.0_4_9";
    public static final int START_ACTIVATION_POLICY = 2;
    private static CDTUIBridgePlugin INSTANCE;
    private ResourceBundle resourceBundle;
    private ActiveFoldingEditorTracker editorTracker;
    private LandmarkMarkerManager landmarkMarkerManager = new LandmarkMarkerManager();
    private InterestInducingProblemListener problemListener = new InterestInducingProblemListener();
    private CDTEditorMonitor cEditingMonitor;
    private InterestUpdateDeltaListener cElementChangeListener = new InterestUpdateDeltaListener();

    public CDTUIBridgePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initDefaultPrefs();
        if (this.getPreferenceStore().getBoolean(MYLYN_FIRST_RUN)) {
            this.getPreferenceStore().setValue(MYLYN_FIRST_RUN, false);
            CDTUiUtil.installContentAssist(CUIPlugin.getDefault().getPreferenceStore(), true);
        }
    }

    private void lazyStart() {
        ContextCorePlugin.getContextManager().addListener((AbstractContextListener)this.landmarkMarkerManager);
        this.cEditingMonitor = new CDTEditorMonitor();
        MonitorUiPlugin.getDefault().getSelectionMonitors().add(this.cEditingMonitor);
        this.installEditorTracker(PlatformUI.getWorkbench());
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.cElementChangeListener);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.problemListener);
        if (this.getPreferenceStore().getBoolean("org.eclipse.cdt.mylyn.ui.interest.prediction.errors")) {
            this.problemListener.enable();
        }
    }

    private void initDefaultPrefs() {
        this.getPreferenceStore().setDefault("org.eclipse.cdt.mylyn.ui.interest.prediction.errors", false);
        this.getPreferenceStore().setDefault(MYLYN_FIRST_RUN, true);
    }

    private void lazyStop() {
        ContextCorePlugin.getContextManager().removeListener((AbstractContextListener)this.landmarkMarkerManager);
        MonitorUiPlugin.getDefault().getSelectionMonitors().remove((Object)this.cEditingMonitor);
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.cElementChangeListener);
    }

    public void stop(BundleContext context) throws Exception {
        this.lazyStop();
        super.stop(context);
        INSTANCE = null;
        this.resourceBundle = null;
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new ActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof CEditor) {
                        CEditor editor = (CEditor)part;
                        this.editorTracker.registerEditor(editor);
                        ActiveFoldingListener.resetProjection(editor);
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    public static CDTUIBridgePlugin getDefault() {
        return INSTANCE;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CDTUIBridgePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.mylyn.internal.ui.PluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(CDTUIBridgePlugin.getResourceString(key), args);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public ActiveFoldingEditorTracker getEditorTracker() {
        return this.editorTracker;
    }

    public static class CDTUIBridgeStartup
    implements IContextUiStartup {
        public void lazyStartup() {
            CDTUIBridgePlugin.getDefault().lazyStart();
        }
    }
}

