/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.cygwin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.core.IBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.gnu.ui.GnuUIPlugin;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class CygwinPathResolver
implements IBuildPathResolver {
    private static final String TOOL = "/cygpath -w -p ";
    private static final char BS = '\\';
    private static final char SLASH = '/';
    private static final String PROPERTY_OS_NAME = "os.name";
    private static final String PROPERTY_OS_VALUE = "windows";
    private static final String SP = " ";
    private static final String REGISTRY_KEY = "SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\";
    private static final String PATH_NAME = "native";
    private static final String EMPTY = "";
    private static final String SSLASH = "/";
    private static final String BSLASH = "\\\\";
    private static final String BINPATTERN = "/usr/bin";
    private static final String ETCPATTERN = "/etc";
    private static final String ROOTPATTERN = "/";
    private static final String DELIMITER_UNIX = ":";
    private static final String DELIMITER_WIN = ";";
    private static final String GCC_VERSION_CMD = "gcc --version";
    private static final String MINGW_SPECIAL = "mingw ";
    private static final String CYGWIN_SPECIAL = "cygwin ";
    private static boolean checked = false;
    private static String binCygwin = null;
    private static String rootCygwin = null;
    private static String etcCygwin = null;

    public String[] resolveBuildPaths(int pathType, String variableName, String variableValue, IConfiguration configuration) {
        if (!CygwinPathResolver.isWindows()) {
            return variableValue.split(DELIMITER_UNIX);
        }
        if (CygwinPathResolver.isMinGW(configuration)) {
            return variableValue.split(DELIMITER_WIN);
        }
        String[] result = variableValue.split(DELIMITER_UNIX);
        String exePath = CygwinPathResolver.getBinPath();
        if (exePath == null) {
            return result;
        }
        File file = new File(exePath);
        if (!file.exists() || !file.isDirectory()) {
            return result;
        }
        String s = String.valueOf(exePath) + TOOL + variableValue;
        String[] lines = CygwinPathResolver.exec(s, configuration);
        if (lines != null && lines.length > 0) {
            result = lines[0].replace('\\', '/').split(DELIMITER_WIN);
        }
        return result;
    }

    public static String getEtcPath() {
        if (!checked) {
            CygwinPathResolver.checkRegistry();
        }
        return etcCygwin;
    }

    public static String getBinPath() {
        if (!checked) {
            CygwinPathResolver.checkRegistry();
        }
        return binCygwin;
    }

    public static String getRootPath() {
        if (!checked) {
            CygwinPathResolver.checkRegistry();
        }
        return rootCygwin;
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE);
    }

    private static String read(boolean user, String pattern) {
        String tail = EMPTY;
        while (pattern.length() > 0) {
            int pos;
            String key = REGISTRY_KEY + pattern;
            WindowsRegistry registry = WindowsRegistry.getRegistry();
            if (registry != null) {
                String s;
                String string = s = user ? registry.getCurrentUserValue(key, PATH_NAME) : registry.getLocalMachineValue(key, PATH_NAME);
                if (s != null) {
                    return s.concat(tail).replaceAll(BSLASH, "/");
                }
            }
            if (pattern.equals("/") || (pos = pattern.lastIndexOf(47)) < 0) break;
            tail = String.valueOf(pattern.substring(pos, pattern.length())) + tail;
            pattern = pos == 0 ? "/" : pattern.substring(0, pos);
        }
        return null;
    }

    private static synchronized void checkRegistry() {
        if (checked) {
            return;
        }
        etcCygwin = null;
        binCygwin = null;
        rootCygwin = null;
        if (!CygwinPathResolver.isWindows()) {
            return;
        }
        int i = 0;
        while (i < 2) {
            if (etcCygwin == null) {
                etcCygwin = CygwinPathResolver.read(i == 0, ETCPATTERN);
            }
            if (binCygwin == null) {
                binCygwin = CygwinPathResolver.read(i == 0, BINPATTERN);
            }
            if (rootCygwin == null) {
                rootCygwin = CygwinPathResolver.read(i == 0, "/");
            }
            ++i;
        }
        checked = true;
    }

    private static String[] exec(String cmd, IConfiguration cfg) {
        try {
            IEnvironmentVariable[] vars = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true);
            String[] env = new String[vars.length];
            int i = 0;
            while (i < env.length) {
                env[i] = String.valueOf(vars[i].getName()) + "=";
                String value = vars[i].getValue();
                if (value != null) {
                    int n = i;
                    env[n] = String.valueOf(env[n]) + value;
                }
                ++i;
            }
            Process proc = ProcessFactory.getFactory().exec(cmd.split(SP), env);
            if (proc != null) {
                String s;
                InputStream ein = proc.getInputStream();
                BufferedReader d1 = new BufferedReader(new InputStreamReader(ein));
                ArrayList<String> ls = new ArrayList<String>(10);
                while ((s = d1.readLine()) != null) {
                    ls.add(s);
                }
                ein.close();
                return ls.toArray(new String[0]);
            }
        }
        catch (IOException e) {
            GnuUIPlugin.getDefault().log(e);
        }
        return null;
    }

    public static boolean isMinGW(IConfiguration cfg) {
        String[] versionInfo = CygwinPathResolver.exec(GCC_VERSION_CMD, cfg);
        if (versionInfo != null) {
            int i = 0;
            while (i < versionInfo.length) {
                if (versionInfo[i].indexOf(MINGW_SPECIAL) != -1) {
                    return true;
                }
                if (versionInfo[i].indexOf(CYGWIN_SPECIAL) != -1) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }
}

