/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.event.MIDestroyedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIInferiorSignalExitEvent
extends MIDestroyedEvent {
    String sigName = "";
    String sigMeaning = "";
    MIExecAsyncOutput exec = null;
    MIResultRecord rr = null;

    public MIInferiorSignalExitEvent(MISession source, MIExecAsyncOutput async) {
        super(source, async.getToken());
        this.exec = async;
        this.parse();
    }

    public MIInferiorSignalExitEvent(MISession source, MIResultRecord record) {
        super(source, record.getToken());
        this.rr = record;
        this.parse();
    }

    public String getName() {
        return this.sigName;
    }

    public String getMeaning() {
        return this.sigMeaning;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("signal-name=" + this.sigName + "\n");
        buffer.append("signal-meaning=" + this.sigMeaning + "\n");
        return buffer.toString();
    }

    void parse() {
        MIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("signal-name")) {
                    this.sigName = str;
                } else if (var.equals("signal-meaning")) {
                    this.sigMeaning = str;
                }
                ++i;
            }
        }
    }
}

