/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTargetAction
extends SelectionListenerAction {
    private final Shell shell;

    public DeleteTargetAction(Shell shell) {
        super(MakeUIPlugin.getResourceString("DeleteTargetAction.label"));
        this.shell = shell;
        this.setToolTipText(MakeUIPlugin.getResourceString("DeleteTargetAction.tooltip"));
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    boolean confirmDelete() {
        String msg;
        String title;
        List<?> targets = this.getSelectedElements();
        if (targets.size() == 1) {
            title = MakeUIPlugin.getResourceString("DeleteTargetAction.title.confirmDeletion");
            IMakeTarget target = (IMakeTarget)targets.get(0);
            msg = MessageFormat.format((String)MakeUIPlugin.getResourceString("DeleteTargetAction.message.confirmDeleteion"), (Object[])new Object[]{target.getName()});
        } else {
            title = MakeUIPlugin.getResourceString("DeleteTargetAction.title.confirmMultipleDeletion");
            msg = MessageFormat.format((String)MakeUIPlugin.getResourceString("DeleteTargetAction.message.confirmMultipleDeletion"), (Object[])new Object[]{new Integer(targets.size())});
        }
        return MessageDialog.openQuestion((Shell)this.shell, (String)title, (String)msg);
    }

    public void run() {
        if (!this.canDelete() || !this.confirmDelete()) {
            return;
        }
        IMakeTargetManager manager = MakeCorePlugin.getDefault().getTargetManager();
        try {
            for (Object target : this.getSelectedElements()) {
                if (!(target instanceof IMakeTarget)) continue;
                manager.removeTarget((IMakeTarget)target);
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.errorDialog(this.shell, MakeUIPlugin.getResourceString("DeleteTargetAction.exception.removeError"), MakeUIPlugin.getResourceString("DeleteTargetAction.exception.errorDeletingBuildTarget"), e);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canDelete();
    }

    private List<?> getSelectedElements() {
        return this.getStructuredSelection().toList();
    }

    private boolean canDelete() {
        List<?> elements = this.getSelectedElements();
        for (Object element : elements) {
            if (element instanceof IMakeTarget) continue;
            return false;
        }
        return elements.size() > 0;
    }
}

