/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitTaskJob
extends SubmitJob {
    private final TaskRepository taskRepository;
    private final TaskData taskData;
    private final AbstractRepositoryConnector connector;
    private IStatus errorStatus;
    private ITask task;
    private final Set<TaskAttribute> oldAttributes;
    private final TaskDataManager taskDataManager;
    private RepositoryResponse response;

    public SubmitTaskJob(TaskDataManager taskDataManager, AbstractRepositoryConnector connector, TaskRepository taskRepository, ITask task, TaskData taskData, Set<TaskAttribute> oldAttributes) {
        super("Submitting Task");
        this.taskDataManager = taskDataManager;
        this.connector = connector;
        this.taskRepository = taskRepository;
        this.task = task;
        this.taskData = taskData;
        this.oldAttributes = oldAttributes;
        this.setRule(new ITasksCoreConstants.MutexSchedulingRule());
    }

    /*
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor jobMonitor) {
        block10: {
            this.monitor.attach(jobMonitor);
            try {
                this.monitor.beginTask(Messages.SubmitTaskJob_Submitting_task, 2 * (1 + this.getSubmitJobListeners().length) * 100);
                AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
                this.monitor.subTask(Messages.SubmitTaskJob_Sending_data);
                this.response = taskDataHandler.postTaskData(this.taskRepository, this.taskData, this.oldAttributes, Policy.subMonitorFor((IProgressMonitor)this.monitor, (int)100));
                if (this.response == null || this.response.getTaskId() == null) {
                    throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.core", 7, "Task could not be created. No additional information was provided by the connector."));
                }
                this.fireTaskSubmitted((IProgressMonitor)this.monitor);
                String taskId = this.response.getTaskId();
                this.monitor.subTask(Messages.SubmitTaskJob_Receiving_data);
                TaskData updatedTaskData = this.connector.getTaskData(this.taskRepository, taskId, Policy.subMonitorFor((IProgressMonitor)this.monitor, (int)100));
                this.task = this.createTask((IProgressMonitor)this.monitor, updatedTaskData);
                this.taskDataManager.putSubmittedTaskData(this.task, updatedTaskData);
                this.fireTaskSynchronized((IProgressMonitor)this.monitor);
            }
            catch (CoreException e) {
                this.errorStatus = e.getStatus();
                this.monitor.done();
                break block10;
            }
            catch (OperationCanceledException operationCanceledException) {
                this.errorStatus = Status.CANCEL_STATUS;
                break block10;
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Unexpected error during task submission", (Throwable)e));
                this.errorStatus = new Status(4, "org.eclipse.mylyn.tasks.core", "Unexpected error: " + e.getMessage(), (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.monitor.done();
                break block10;
            }
            {
                finally {
                    this.monitor.done();
                }
            }
            this.monitor.done();
        }
        this.fireDone();
        return this.errorStatus == Status.CANCEL_STATUS ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private ITask createTask(IProgressMonitor monitor, TaskData updatedTaskData) throws CoreException {
        if (this.taskData.isNew()) {
            this.task = new TaskTask(this.connector.getConnectorKind(), this.taskRepository.getRepositoryUrl(), updatedTaskData.getTaskId());
        }
        return this.task;
    }

    @Override
    public RepositoryResponse getResponse() {
        return this.response;
    }

    @Override
    public IStatus getStatus() {
        return this.errorStatus;
    }

    @Override
    public ITask getTask() {
        return this.task;
    }
}

