/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;

public class CoreFileLaunchDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block15: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(LaunchMessages.getString("CoreFileLaunchDelegate.Launching_postmortem_debugger"), 10);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                monitor.worked(1);
                IPath exePath = this.verifyProgramPath(config);
                ICProject project = this.verifyCProject(config);
                IBinaryParser.IBinaryObject exeFile = this.verifyBinary(project, exePath);
                ICDebugConfiguration debugConfig = this.getDebugConfig(config);
                ICDISession dsession = null;
                ICProject cproject = CDebugUtils.getCProject((ILaunchConfiguration)config);
                String path = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
                if (path == null) {
                    File file;
                    IPath corefile = this.promptForCoreFilePath((IProject)cproject.getResource(), debugConfig);
                    if (corefile == null) {
                        this.cancel(LaunchMessages.getString("CoreFileLaunchDelegate.No_Corefile_selected"), 108);
                    }
                    if (!(file = new File(corefile.toString())).exists() || !file.canRead()) {
                        this.cancel(LaunchMessages.getString("CoreFileLaunchDelegate.Corefile_not_readable"), 108);
                    }
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", corefile.toString());
                    wc.launch(mode, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
                    wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
                    this.cancel("", -1);
                    break block15;
                }
                File file = new File(path);
                if (!file.exists() || !file.canRead()) {
                    this.abort(LaunchMessages.getString("CoreFileLaunchDelegate.Corefile_not_readable"), null, 108);
                }
                dsession = debugConfig.createDebugger().createDebuggerSession(launch, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                try {
                    this.setDefaultSourceLocator(launch, config);
                    ICDITarget[] targets = dsession.getTargets();
                    int i = 0;
                    while (i < targets.length) {
                        Process process = targets[i].getProcess();
                        IProcess iprocess = null;
                        if (process != null) {
                            iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                        }
                        CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (boolean)false);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    try {
                        dsession.terminate();
                    }
                    catch (CDIException cDIException) {}
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected IPath promptForCoreFilePath(IProject project, ICDebugConfiguration debugConfig) throws CoreException {
        Object result;
        Status fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status processPrompt = new Status(1, "org.eclipse.cdt.launch", 101, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)fPromptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)processPrompt, (Object)new Object[]{project, debugConfig})) instanceof IPath) {
            return (IPath)result;
        }
        return null;
    }

    public String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) {
        return true;
    }
}

