/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IModificationStatus;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.runtime.Status;

public class ModificationStatus
extends Status
implements IModificationStatus {
    private HashMap fUnsupportedProperties = new HashMap();
    private HashMap fUnsupportedRequiredProperties = new HashMap();
    private HashSet fUndefinedProperties = new HashSet();
    private ITool[][] fToolConflicts;
    private ITool[] fNonManagedBuildTools;
    public static final ModificationStatus OK = new ModificationStatus(0, "", null);

    ModificationStatus(String msg) {
        this(msg, null);
    }

    ModificationStatus(String msg, Throwable t) {
        this(4, msg, t);
    }

    ModificationStatus(int severity, String msg, Throwable t) {
        super(severity, ManagedBuilderCorePlugin.getUniqueIdentifier(), msg, t);
        this.fToolConflicts = new ITool[0][];
        this.fNonManagedBuildTools = new ITool[0];
    }

    ModificationStatus(Map unsupportedRequiredProps, Map unsupportedProps, Set undefinedProps, ITool[][] conflicts, ITool[] nonMbsTools) {
        super(0, ManagedBuilderCorePlugin.getUniqueIdentifier(), "");
        int severity = 0;
        int flags = 0;
        if (unsupportedRequiredProps != null && unsupportedRequiredProps.size() != 0) {
            this.fUnsupportedRequiredProperties.putAll(unsupportedRequiredProps);
            this.fUnsupportedProperties.putAll(unsupportedRequiredProps);
            flags |= 0xC;
            severity = 4;
        }
        if (unsupportedProps != null && unsupportedProps.size() != 0) {
            this.fUnsupportedProperties.putAll(unsupportedProps);
            flags |= 2;
            if (severity == 0) {
                severity = 2;
            }
        }
        if (undefinedProps != null && undefinedProps.size() != 0) {
            this.fUndefinedProperties.addAll(undefinedProps);
            flags |= 8;
            if (severity == 0) {
                severity = 2;
            }
        }
        if (conflicts != null && conflicts.length != 0) {
            this.fToolConflicts = new ITool[conflicts.length][];
            int i = 0;
            while (i < conflicts.length) {
                this.fToolConflicts[i] = (ITool[])conflicts[i].clone();
                ++i;
            }
            flags |= 1;
            if (severity == 0) {
                severity = 2;
            }
        } else {
            this.fToolConflicts = new ITool[0][];
        }
        if (nonMbsTools != null && nonMbsTools.length != 0) {
            this.fNonManagedBuildTools = (ITool[])nonMbsTools.clone();
            flags |= 0x10;
            severity = 4;
        } else {
            this.fNonManagedBuildTools = new ITool[0];
        }
        if (flags != 0) {
            this.setCode(flags);
        }
        if (severity != 0) {
            this.setSeverity(severity);
        }
    }

    public Map getUnsupportedProperties() {
        return (HashMap)this.fUnsupportedProperties.clone();
    }

    public Map getUnsupportedRequiredProperties() {
        return (HashMap)this.fUnsupportedRequiredProperties.clone();
    }

    public Set getUndefinedProperties() {
        return (HashSet)this.fUndefinedProperties.clone();
    }

    public ITool[][] getToolsConflicts() {
        ITool[][] copy = new ITool[this.fToolConflicts.length][];
        int i = 0;
        while (i < this.fToolConflicts.length) {
            copy[i] = (ITool[])this.fToolConflicts[i].clone();
            ++i;
        }
        return copy;
    }

    public ITool[] getNonManagedBuildTools() {
        return (ITool[])this.fNonManagedBuildTools.clone();
    }
}

