/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildTargetPlatformData;
import org.eclipse.core.runtime.PluginVersionIdentifier;

public class TargetPlatform
extends BuildObject
implements ITargetPlatform {
    private static final String EMPTY_STRING = new String();
    private ITargetPlatform superClass;
    private String superClassId;
    private IToolChain parent;
    private String unusedChildren;
    private String errorParserIds;
    private Boolean isAbstract;
    private List osList;
    private List archList;
    private List binaryParserList;
    private boolean isExtensionTargetPlatform = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private BuildTargetPlatformData fTargetPlatformData;

    public TargetPlatform(IToolChain parent, IManagedConfigElement element, String managedBuildRevision) {
        this.parent = parent;
        this.isExtensionTargetPlatform = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionTargetPlatform(this);
    }

    public TargetPlatform(ToolChain parent, ITargetPlatform superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionTargetPlatform = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionTargetPlatform(this);
        } else {
            this.fTargetPlatformData = new BuildTargetPlatformData(this);
            this.setDirty(true);
        }
    }

    public TargetPlatform(IToolChain parent, ICStorageElement element, String managedBuildRevision) {
        this.parent = parent;
        this.isExtensionTargetPlatform = false;
        this.fTargetPlatformData = new BuildTargetPlatformData(this);
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
    }

    public TargetPlatform(IToolChain parent, String Id, String name, TargetPlatform targetPlatform) {
        this.parent = parent;
        ITargetPlatform iTargetPlatform = this.superClass = targetPlatform.isExtensionTargetPlatform ? targetPlatform : targetPlatform.superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionTargetPlatform = false;
        this.fTargetPlatformData = new BuildTargetPlatformData(this);
        if (targetPlatform != null) {
            this.setManagedBuildRevision(targetPlatform.getManagedBuildRevision());
        }
        if (targetPlatform.unusedChildren != null) {
            this.unusedChildren = new String(targetPlatform.unusedChildren);
        }
        if (targetPlatform.errorParserIds != null) {
            this.errorParserIds = new String(targetPlatform.errorParserIds);
        }
        if (targetPlatform.isAbstract != null) {
            this.isAbstract = new Boolean(targetPlatform.isAbstract);
        }
        if (targetPlatform.osList != null) {
            this.osList = new ArrayList(targetPlatform.osList);
        }
        if (targetPlatform.archList != null) {
            this.archList = new ArrayList(targetPlatform.archList);
        }
        if (targetPlatform.binaryParserList != null) {
            this.binaryParserList = new ArrayList(targetPlatform.binaryParserList);
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String bpars;
        String arch;
        String os;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if ((os = element.getAttribute("osList")) != null) {
            this.osList = new ArrayList();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.osList.add(osTokens[i].trim());
                ++i;
            }
        }
        if ((arch = element.getAttribute("archList")) != null) {
            this.archList = new ArrayList();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.archList.add(archTokens[j].trim());
                ++j;
            }
        }
        if ((bpars = element.getAttribute("binaryParser")) != null) {
            this.binaryParserList = new ArrayList();
            String[] bparsTokens = CDataUtil.stringToArray((String)bpars, (String)";");
            int j = 0;
            while (j < bparsTokens.length) {
                this.binaryParserList.add(bparsTokens[j].trim());
                ++j;
            }
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        String bpars;
        int j;
        String arch;
        String os;
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionTargetPlatform(this.superClassId);
        }
        if (element.getAttribute("unusedChildren") != null) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.getAttribute("isAbstract") != null && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.getAttribute("osList") != null && (os = element.getAttribute("osList")) != null) {
            this.osList = new ArrayList();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.osList.add(osTokens[i].trim());
                ++i;
            }
        }
        if (element.getAttribute("archList") != null && (arch = element.getAttribute("archList")) != null) {
            this.archList = new ArrayList();
            String[] archTokens = arch.split(",");
            j = 0;
            while (j < archTokens.length) {
                this.archList.add(archTokens[j].trim());
                ++j;
            }
        }
        if (element.getAttribute("binaryParser") != null && (bpars = element.getAttribute("binaryParser")) != null) {
            this.binaryParserList = new ArrayList();
            String[] bparsTokens = CDataUtil.stringToArray((String)bpars, (String)";");
            j = 0;
            while (j < bparsTokens.length) {
                this.binaryParserList.add(bparsTokens[j].trim());
                ++j;
            }
        }
    }

    public void serialize(ICStorageElement element) {
        String current;
        String listValue;
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.binaryParserList != null) {
            ListIterator bparsIter = this.binaryParserList.listIterator();
            listValue = EMPTY_STRING;
            while (bparsIter.hasNext()) {
                current = (String)bparsIter.next();
                listValue = String.valueOf(listValue) + current;
                if (!bparsIter.hasNext()) continue;
                listValue = String.valueOf(listValue) + ";";
            }
            element.setAttribute("binaryParser", listValue);
        }
        if (this.osList != null) {
            ListIterator osIter = this.osList.listIterator();
            listValue = EMPTY_STRING;
            while (osIter.hasNext()) {
                current = (String)osIter.next();
                listValue = String.valueOf(listValue) + current;
                if (!osIter.hasNext()) continue;
                listValue = String.valueOf(listValue) + ",";
            }
            element.setAttribute("osList", listValue);
        }
        if (this.archList != null) {
            ListIterator archIter = this.archList.listIterator();
            listValue = EMPTY_STRING;
            while (archIter.hasNext()) {
                current = (String)archIter.next();
                listValue = String.valueOf(listValue) + current;
                if (!archIter.hasNext()) continue;
                listValue = String.valueOf(listValue) + ",";
            }
            element.setAttribute("archList", listValue);
        }
        this.isDirty = false;
    }

    public IToolChain getParent() {
        return this.parent;
    }

    public ITargetPlatform getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public String getBinaryParserId() {
        String[] ids = this.getBinaryParserList();
        if (ids.length > 0) {
            return ids[0];
        }
        return EMPTY_STRING;
    }

    public String[] getBinaryParserList() {
        if (this.binaryParserList == null) {
            if (this.superClass != null) {
                return this.superClass.getBinaryParserList();
            }
            return new String[0];
        }
        return this.binaryParserList.toArray(new String[this.binaryParserList.size()]);
    }

    public String[] getArchList() {
        if (this.archList == null) {
            if (this.superClass != null) {
                return this.superClass.getArchList();
            }
            return new String[]{"all"};
        }
        return this.archList.toArray(new String[this.archList.size()]);
    }

    public String[] getOSList() {
        if (this.osList == null) {
            if (this.superClass != null) {
                return this.superClass.getOSList();
            }
            return new String[]{"all"};
        }
        return this.osList.toArray(new String[this.osList.size()]);
    }

    public void setBinaryParserId(String id) {
        if (id == null) {
            this.setBinaryParserList(new String[0]);
        } else {
            this.setBinaryParserList(new String[]{id});
        }
    }

    public void setBinaryParserList(String[] ids) {
        if (ids != null) {
            if (this.binaryParserList == null) {
                this.binaryParserList = new ArrayList();
            } else {
                this.binaryParserList.clear();
            }
            int i = 0;
            while (i < ids.length) {
                this.binaryParserList.add(ids[i]);
                ++i;
            }
        } else {
            this.binaryParserList = null;
        }
        this.setDirty(true);
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    public void setOSList(String[] OSs) {
        if (this.osList == null) {
            this.osList = new ArrayList();
        } else {
            this.osList.clear();
        }
        int i = 0;
        while (i < OSs.length) {
            this.osList.add(OSs[i]);
            ++i;
        }
        this.setDirty(true);
    }

    public void setArchList(String[] archs) {
        if (this.archList == null) {
            this.archList = new ArrayList();
        } else {
            this.archList.clear();
        }
        int i = 0;
        while (i < archs.length) {
            this.archList.add(archs[i]);
            ++i;
        }
        this.setDirty(true);
    }

    public boolean isExtensionElement() {
        return this.isExtensionTargetPlatform;
    }

    public boolean isDirty() {
        if (this.isExtensionTargetPlatform) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionTargetPlatform(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "targetPlatform", this.getId());
                }
            }
        }
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }

    public CTargetPlatformData getTargetPlatformData() {
        return this.fTargetPlatformData;
    }
}

