/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine.processes;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AppendToMBSStringOptionValue
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        boolean autoBuilding = workspaceDesc.isAutoBuilding();
        workspaceDesc.setAutoBuilding(false);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
        ProcessArgument[][] resourcePathObjects = args[1].getComplexArrayValue();
        boolean modified = false;
        int i = 0;
        while (i < resourcePathObjects.length) {
            ProcessArgument[] resourcePathObject = resourcePathObjects[i];
            String id = resourcePathObject[0].getSimpleValue();
            String value = resourcePathObject[1].getSimpleValue();
            String path = resourcePathObject[2].getSimpleValue();
            try {
                modified |= this.setOptionValue(projectHandle, id, value, path);
            }
            catch (BuildException e) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AppendToMBSStringOptionValue.0")) + e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        if (modified) {
            ManagedBuildManager.saveBuildInfo(projectHandle, true);
        }
        workspaceDesc.setAutoBuilding(autoBuilding);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
    }

    private boolean setOptionValue(IProject projectHandle, String id, String value, String path) throws BuildException, ProcessFailureException {
        IConfiguration[] projectConfigs = ManagedBuildManager.getBuildInfo((IResource)projectHandle).getManagedProject().getConfigurations();
        boolean resource = path != null && !path.equals("") && !path.equals("/");
        boolean modified = false;
        int i = 0;
        while (i < projectConfigs.length) {
            IConfiguration config = projectConfigs[i];
            IResourceConfiguration resourceConfig = null;
            if (resource) {
                resourceConfig = config.getResourceConfiguration(path);
                if (resourceConfig == null) {
                    IFile file = projectHandle.getFile(path);
                    if (file == null) {
                        throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AppendToMBSStringOptionValue.3")) + path);
                    }
                    resourceConfig = config.createResourceConfiguration(file);
                }
                ITool[] tools = resourceConfig.getTools();
                int j = 0;
                while (j < tools.length) {
                    modified |= this.setOptionForResourceConfig(id, value, resourceConfig, tools[j].getOptions(), tools[j]);
                    ++j;
                }
            } else {
                IToolChain toolChain = config.getToolChain();
                modified |= this.setOptionForConfig(id, value, config, toolChain.getOptions(), toolChain);
                ITool[] tools = config.getTools();
                int j = 0;
                while (j < tools.length) {
                    modified |= this.setOptionForConfig(id, value, config, tools[j].getOptions(), tools[j]);
                    ++j;
                }
            }
            ++i;
        }
        return modified;
    }

    private boolean setOptionForResourceConfig(String id, String value, IResourceConfiguration resourceConfig, IOption[] options, IHoldsOptions optionHolder) throws BuildException {
        boolean modified = false;
        String lowerId = id.toLowerCase();
        int i = 0;
        while (i < options.length) {
            if (options[i].getId().toLowerCase().matches(lowerId) && options[i].getValueType() == 2) {
                String oldValue = options[i].getStringValue();
                String newValue = String.valueOf(oldValue) + value;
                IOption setOption = ManagedBuildManager.setOption((IResourceInfo)resourceConfig, optionHolder, options[i], newValue);
                if (setOption == null) {
                    setOption = options[i];
                }
                modified = true;
            }
            ++i;
        }
        return modified;
    }

    private boolean setOptionForConfig(String id, String value, IConfiguration config, IOption[] options, IHoldsOptions optionHolder) throws BuildException {
        boolean modified = false;
        String lowerId = id.toLowerCase();
        int i = 0;
        while (i < options.length) {
            if (options[i].getId().toLowerCase().matches(lowerId) && options[i].getValueType() == 2) {
                String oldValue = options[i].getStringValue();
                String newValue = String.valueOf(oldValue) + value;
                IOption setOption = ManagedBuildManager.setOption(config, optionHolder, options[i], newValue);
                if (setOption == null) {
                    setOption = options[i];
                }
                modified = true;
            }
            ++i;
        }
        return modified;
    }
}

