/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.CompatibilityMarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.FiltersConfigurationDialog;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerComparator;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerMap;
import org.eclipse.ui.internal.views.markers.MarkerSortUtil;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class CachedMarkerBuilder {
    private static final MarkerCategory[] EMPTY_CATEGORY_ARRAY = new MarkerCategory[0];
    private static final MarkerEntry[] EMPTY_ENTRY_ARRAY = new MarkerEntry[0];
    private static final int SHORT_DELAY = 100;
    private static final int TIME_OUT = 30000;
    private static final String TAG_FILTERS_SECTION = "filterGroups";
    private static final String TAG_GROUP_ENTRY = "filterGroup";
    private static final String TAG_AND = "andFilters";
    private static final String TAG_CATEGORY_GROUP = "categoryGroup";
    private static final String TAG_COLUMN_VISIBILITY = "visible";
    private static final String VALUE_NONE = "none";
    private static final String TAG_LEGACY_FILTER_ENTRY = "filter";
    private static final Integer[] EMPTY_MARKER_COUNTS = new Integer[]{new Integer(0), new Integer(0), new Integer(0)};
    private boolean building = true;
    private MarkerCategory[] categories;
    private MarkerMap currentMap = null;
    private MarkerContentGenerator generator;
    private Job markerProcessJob;
    private IWorkbenchSiteProgressService progressService;
    private Job updateJob;
    private MarkerGroup categoryGroup;
    private Collection enabledFilters;
    private Collection filters;
    private IResource[] focusResources = MarkerSupportInternalUtilities.EMPTY_RESOURCE_ARRAY;
    private MarkerField[] visibleFields;
    private boolean andFilters = false;
    private MarkerComparator comparator;
    private IMemento memento;
    private String viewId;
    private long preBuildTime = -1L;
    private IResourceChangeListener resourceListener;
    private IPropertyChangeListener preferenceListener;

    public CachedMarkerBuilder(MarkerContentGenerator contentGenerator, String id, IMemento memento) {
        this.generator = contentGenerator;
        this.viewId = id;
        this.initialiseVisibleFields(memento);
        this.initializePreferenceListener();
        this.memento = memento;
        if (memento == null) {
            this.setDefaultCategoryGroup(contentGenerator);
        } else {
            String categoryGroupID = memento.getString(TAG_CATEGORY_GROUP);
            if (categoryGroupID == null) {
                this.setDefaultCategoryGroup(contentGenerator);
            } else if (categoryGroupID.equals(VALUE_NONE)) {
                this.categoryGroup = null;
            } else {
                MarkerGroup newGroup = contentGenerator.getMarkerGroup(categoryGroupID);
                if (newGroup == null) {
                    this.setDefaultCategoryGroup(contentGenerator);
                } else {
                    this.categoryGroup = newGroup;
                }
            }
        }
        this.createMarkerProcessJob();
        this.resourceListener = this.getUpdateListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 25);
    }

    private void addResources(Collection resourceCollection, ResourceMapping resourceMapping) {
        try {
            ResourceTraversal[] traversals = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                IResource[] result = traversal.getResources();
                int j = 0;
                while (j < result.length) {
                    resourceCollection.add(result[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
    }

    boolean andFilters() {
        return this.andFilters;
    }

    void buildAllMarkers(IProgressMonitor monitor) {
        this.building = true;
        try {
            monitor.beginTask(MarkerMessages.MarkerView_19, 60);
            monitor.subTask(MarkerMessages.MarkerView_waiting_on_changes);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(MarkerMessages.MarkerView_searching_for_markers);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
            MarkerMap newMarkers = this.generator.generateFilteredMarkers(subMonitor, this.andFilters(), this.focusResources, this.getEnabledFilters());
            if (monitor.isCanceled()) {
                return;
            }
            this.sortAndMakeCategories((IProgressMonitor)new SubProgressMonitor(monitor, 30), newMarkers);
            monitor.done();
        }
        finally {
            this.building = false;
        }
    }

    private void cancelJobs() {
        this.markerProcessJob.cancel();
        this.updateJob.cancel();
    }

    Collection createFilterConfigurationFields() {
        ArrayList<FilterConfigurationArea> result = new ArrayList<FilterConfigurationArea>();
        int i = 0;
        while (i < this.visibleFields.length) {
            FilterConfigurationArea area = MarkerSupportInternalUtilities.generateFilterArea(this.visibleFields[i]);
            if (area != null) {
                result.add(area);
            }
            ++i;
        }
        return result;
    }

    private void createMarkerProcessJob() {
        this.markerProcessJob = new Job(MarkerMessages.MarkerView_processUpdates){

            public boolean belongsTo(Object family) {
                return MarkerContentGenerator.CACHE_UPDATE_FAMILY == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                CachedMarkerBuilder.this.updateJob.cancel();
                CachedMarkerBuilder.this.buildAllMarkers(monitor);
                CachedMarkerBuilder.this.updateJob.schedule();
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                if (CachedMarkerBuilder.this.preBuildTime > 0L && System.currentTimeMillis() - CachedMarkerBuilder.this.preBuildTime < 30000L) {
                    return false;
                }
                CachedMarkerBuilder.this.preBuildTime = -1L;
                return IDEWorkbenchPlugin.getDefault().getBundle().getState() == 32;
            }
        };
        this.markerProcessJob.setSystem(true);
    }

    void disableAllFilters() {
        Collection allFilters = this.getEnabledFilters();
        Iterator enabled = allFilters.iterator();
        while (enabled.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)enabled.next();
            group.setEnabled(false);
        }
        allFilters.clear();
        this.writeFiltersPreference();
        this.scheduleMarkerUpdate();
    }

    void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
    }

    Collection getAllFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList();
            IConfigurationElement[] filterReferences = this.generator.getFilterReferences();
            int i = 0;
            while (i < filterReferences.length) {
                this.filters.add(new MarkerFieldFilterGroup(filterReferences[i], this));
                ++i;
            }
            if (this.viewId.equals("org.eclipse.ui.views.ProblemView")) {
                Iterator problemFilters = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
                while (problemFilters.hasNext()) {
                    this.filters.add(new CompatibilityMarkerFieldFilterGroup((ProblemFilter)problemFilters.next(), this));
                }
            }
            this.loadFiltersPreference();
        }
        return this.filters;
    }

    public MarkerCategory[] getCategories() {
        if (this.building) {
            return null;
        }
        return this.categories;
    }

    MarkerGroup getCategoryGroup() {
        return this.categoryGroup;
    }

    MarkerComparator getComparator() {
        if (this.comparator == null) {
            MarkerField field = null;
            if (this.getCategoryGroup() != null) {
                field = this.getCategoryGroup().getMarkerField();
            }
            this.comparator = new MarkerComparator(field, this.generator.getAllFields());
            this.comparator.restore(this.memento);
        }
        return this.comparator;
    }

    MarkerSupportItem[] getElements() {
        if (this.refreshingMarkers()) {
            return MarkerSupportInternalUtilities.EMPTY_MARKER_ITEM_ARRAY;
        }
        if (this.isShowingHierarchy() && this.categories != null) {
            return this.categories;
        }
        return this.currentMap.toArray();
    }

    Collection getEnabledFilters() {
        if (this.enabledFilters == null) {
            this.enabledFilters = new HashSet();
            Iterator filtersIterator = this.getAllFilters().iterator();
            while (filtersIterator.hasNext()) {
                MarkerFieldFilterGroup next = (MarkerFieldFilterGroup)filtersIterator.next();
                if (!next.isEnabled()) continue;
                this.enabledFilters.add(next);
            }
        }
        return this.enabledFilters;
    }

    MarkerContentGenerator getGenerator() {
        return this.generator;
    }

    Object[] getHiddenFields() {
        MarkerField[] all = this.getGenerator().getAllFields();
        MarkerField[] visible = this.getVisibleFields();
        HashSet<MarkerField> hidden = new HashSet<MarkerField>();
        int i = 0;
        while (i < all.length) {
            hidden.add(all[i]);
            ++i;
        }
        i = 0;
        while (i < visible.length) {
            hidden.remove(visible[i]);
            ++i;
        }
        return hidden.toArray();
    }

    private String getLegacyFiltersPreferenceName() {
        if (this.viewId.equals("org.eclipse.ui.views.BookmarkView")) {
            return "BOOKMARKS_FILTERS";
        }
        if (this.viewId.equals("org.eclipse.ui.views.TaskList")) {
            return "TASKS_FILTERS";
        }
        return "PROBLEMS_FILTERS";
    }

    Integer[] getMarkerCounts() {
        if (this.currentMap == null) {
            return EMPTY_MARKER_COUNTS;
        }
        return this.currentMap.getMarkerCounts();
    }

    MarkerEntry[] getMarkerEntries() {
        if (this.refreshingMarkers()) {
            return EMPTY_ENTRY_ARRAY;
        }
        return this.currentMap.toArray();
    }

    MarkerItem getMarkerItem(IMarker marker) {
        if (this.refreshingMarkers()) {
            return null;
        }
        return this.currentMap.getMarkerItem(marker);
    }

    private String getMementoPreferenceName() {
        return String.valueOf(this.getClass().getName()) + this.viewId;
    }

    MarkerField getPrimarySortField() {
        return this.getComparator().getPrimarySortField();
    }

    int getSortDirection(MarkerField field) {
        if (this.getComparator().descendingFields.contains(field)) {
            return -1;
        }
        return 1;
    }

    int getTotalMarkerCount() {
        MarkerSupportItem[] elements = this.getElements();
        if (elements.length == 0 || elements[0].isConcrete()) {
            return elements.length;
        }
        int length = 0;
        int i = 0;
        while (i < elements.length) {
            length += elements[i].getChildren().length;
            ++i;
        }
        return length;
    }

    private IResourceChangeListener getUpdateListener() {
        return new IResourceChangeListener(){

            private boolean hasMarkerDelta(IResourceChangeEvent event) {
                Iterator markerTypes = CachedMarkerBuilder.this.generator.getMarkerTypes().iterator();
                while (markerTypes.hasNext()) {
                    MarkerType type = (MarkerType)markerTypes.next();
                    if (event.findMarkerDeltas(type.getId(), true).length <= 0) continue;
                    return true;
                }
                return false;
            }

            public void resourceChanged(IResourceChangeEvent event) {
                if (!this.hasMarkerDelta(event)) {
                    return;
                }
                if (event.getType() == 8) {
                    CachedMarkerBuilder.this.preBuild();
                    return;
                }
                if (event.getType() == 16) {
                    CachedMarkerBuilder.this.postBuild();
                    CachedMarkerBuilder.this.scheduleMarkerUpdate();
                    return;
                }
                if (CachedMarkerBuilder.this.progressService == null) {
                    CachedMarkerBuilder.this.markerProcessJob.schedule(30000L);
                } else {
                    CachedMarkerBuilder.this.progressService.schedule(CachedMarkerBuilder.this.markerProcessJob, 30000L);
                }
            }
        };
    }

    MarkerField[] getVisibleFields() {
        return this.visibleFields;
    }

    boolean hasNoMarkers() {
        return this.currentMap == null;
    }

    private void initialiseVisibleFields(IMemento memento) {
        if (memento == null || memento.getChildren(TAG_COLUMN_VISIBILITY).length == 0) {
            MarkerField[] initialFields = this.getGenerator().getInitialVisible();
            this.visibleFields = new MarkerField[initialFields.length];
            System.arraycopy(initialFields, 0, this.visibleFields, 0, initialFields.length);
            return;
        }
        IMemento[] visible = memento.getChildren(TAG_COLUMN_VISIBILITY);
        ArrayList newVisible = new ArrayList();
        MarkerField[] all = this.getGenerator().getAllFields();
        Hashtable<String, MarkerField> allTable = new Hashtable<String, MarkerField>();
        int i = 0;
        while (i < all.length) {
            allTable.put(all[i].getConfigurationElement().getAttribute("id"), all[i]);
            ++i;
        }
        i = 0;
        while (i < visible.length) {
            String key = visible[i].getID();
            if (allTable.containsKey(key)) {
                newVisible.add(allTable.get(key));
            }
            ++i;
        }
        this.visibleFields = new MarkerField[newVisible.size()];
        newVisible.toArray(this.visibleFields);
    }

    private void initializePreferenceListener() {
        this.preferenceListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(CachedMarkerBuilder.this.getMementoPreferenceName())) {
                    CachedMarkerBuilder.this.rebuildFilters();
                }
            }
        };
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    public boolean isBuilding() {
        return this.building;
    }

    boolean isShowingHierarchy() {
        return this.categoryGroup != null;
    }

    private void loadFilterSettings(IMemento memento) {
        if (memento == null) {
            return;
        }
        Boolean andValue = memento.getBoolean(TAG_AND);
        if (andValue != null) {
            this.setAndFilters(andValue);
        }
        IMemento[] children = memento.getChildren(TAG_GROUP_ENTRY);
        int i = 0;
        while (i < children.length) {
            IMemento child = children[i];
            String id = child.getString("IMemento.internal.id");
            if (id != null && !this.loadGroupWithID(child, id)) {
                this.loadUserFilter(child);
            }
            ++i;
        }
    }

    private void loadFiltersFrom(String mementoString) {
        if (mementoString.equals("")) {
            return;
        }
        try {
            this.loadFilterSettings((IMemento)XMLMemento.createReadRoot((Reader)new StringReader(mementoString)));
        }
        catch (WorkbenchException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
    }

    private void loadFiltersPreference() {
        this.loadFiltersFrom(IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(this.getMementoPreferenceName()));
        String legacyFilters = this.getLegacyFiltersPreferenceName();
        String migrationPreference = String.valueOf(legacyFilters) + "_MIGRATE";
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(migrationPreference)) {
            return;
        }
        this.loadLegacyFiltersFrom(IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(legacyFilters));
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(migrationPreference, true);
    }

    private boolean loadGroupWithID(IMemento child, String id) {
        Iterator groups = this.getAllFilters().iterator();
        while (groups.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)groups.next();
            if (!id.equals(group.getID())) continue;
            group.loadSettings(child);
            return true;
        }
        return false;
    }

    private void loadLegacyFilter(IMemento child) {
        MarkerFieldFilterGroup newGroup = new MarkerFieldFilterGroup(null, this);
        newGroup.legacyLoadSettings(child);
        this.getAllFilters().add(newGroup);
    }

    private void loadLegacyFiltersFrom(String mementoString) {
        if (mementoString.equals("")) {
            return;
        }
        try {
            XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
            this.restoreLegacyFilters((IMemento)memento);
        }
        catch (WorkbenchException e) {
            StatusManager.getManager().handle(e.getStatus());
            return;
        }
    }

    private void loadUserFilter(IMemento child) {
        MarkerFieldFilterGroup newGroup = new MarkerFieldFilterGroup(null, this);
        newGroup.loadSettings(child);
        this.getAllFilters().add(newGroup);
    }

    protected void postBuild() {
        this.preBuildTime = -1L;
    }

    protected void preBuild() {
        this.preBuildTime = System.currentTimeMillis();
    }

    protected void rebuildFilters() {
        this.filters = null;
        this.enabledFilters = null;
        this.scheduleMarkerUpdate();
    }

    void refreshContents(IWorkbenchSiteProgressService service) {
        try {
            service.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    if (CachedMarkerBuilder.this.refreshingMarkers()) {
                        return;
                    }
                    CachedMarkerBuilder.this.sortAndMakeCategories(monitor, CachedMarkerBuilder.this.currentMap);
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private boolean refreshingMarkers() {
        if (this.currentMap == null) {
            this.scheduleMarkerUpdate();
            return true;
        }
        return this.building;
    }

    private void restoreLegacyFilters(IMemento memento) {
        IMemento[] sections = null;
        if (memento != null) {
            sections = memento.getChildren(TAG_LEGACY_FILTER_ENTRY);
        }
        int i = 0;
        while (i < sections.length) {
            IMemento child = sections[i];
            String id = child.getString("IMemento.internal.id");
            if (id != null) {
                this.loadLegacyFilter(child);
            }
            ++i;
        }
    }

    void saveState(IMemento memento, MarkerField[] displayedFields) {
        this.getComparator().saveState(memento);
        if (this.categoryGroup == null) {
            memento.putString(TAG_CATEGORY_GROUP, VALUE_NONE);
        } else {
            memento.putString(TAG_CATEGORY_GROUP, this.getCategoryGroup().getId());
        }
        int i = 0;
        while (i < displayedFields.length) {
            memento.createChild(TAG_COLUMN_VISIBILITY, displayedFields[i].getConfigurationElement().getAttribute("id"));
            ++i;
        }
    }

    public void scheduleMarkerUpdate() {
        this.cancelJobs();
        this.currentMap = null;
        this.building = true;
        if (this.progressService != null) {
            this.progressService.schedule(this.markerProcessJob, 100L);
        } else {
            this.markerProcessJob.schedule(100L);
        }
    }

    void setAndFilters(boolean and) {
        this.andFilters = and;
    }

    void setCategoryGroup(MarkerGroup group) {
        this.categoryGroup = group;
        if (group == null) {
            this.getComparator().setCategory(null);
        } else {
            this.getComparator().setCategory(group.getMarkerField());
        }
        this.scheduleMarkerUpdate();
    }

    private void setDefaultCategoryGroup(MarkerContentGenerator contentGenerator) {
        MarkerGroup group;
        String categoryName = contentGenerator.getCategoryName();
        if (categoryName != null && (group = contentGenerator.getMarkerGroup(categoryName)) != null) {
            this.categoryGroup = group;
        }
    }

    void setGenerator(MarkerContentGenerator generator) {
        this.generator = generator;
        this.scheduleMarkerUpdate();
    }

    void setPrimarySortField(MarkerField field) {
        this.getComparator().setPrimarySortField(field);
    }

    void setProgressService(IWorkbenchSiteProgressService service) {
        this.progressService = service;
        if (service != null) {
            service.showBusyForFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            service.showBusyForFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
            service.showBusyForFamily(MarkerContentGenerator.CACHE_UPDATE_FAMILY);
        }
    }

    public void setUpdateJob(Job job) {
        this.updateJob = job;
    }

    void sortAndMakeCategories(IProgressMonitor monitor, MarkerMap newMarkers) {
        if (newMarkers.getSize() == 0) {
            this.categories = EMPTY_CATEGORY_ARRAY;
            this.currentMap = newMarkers;
            monitor.done();
            return;
        }
        if (this.isShowingHierarchy()) {
            MarkerCategory[] markerCategories = this.groupIntoCategories(monitor, newMarkers);
            this.categories = markerCategories;
        }
        monitor.worked(50);
        monitor.subTask(MarkerMessages.MarkerView_queueing_updates);
        if (monitor.isCanceled()) {
            return;
        }
        int limit = MarkerSupportInternalUtilities.getMarkerLimit();
        MarkerEntry[] entries = newMarkers.toArray();
        Comparator comparator = this.getComparator().getFieldsComparator();
        if (this.isShowingHierarchy()) {
            int i = 0;
            while (i < this.categories.length) {
                MarkerCategory category = this.categories[i];
                int avaliable = category.end - category.start + 1;
                int effLimit = limit;
                if (avaliable < effLimit || limit == -1) {
                    effLimit = avaliable;
                }
                MarkerSortUtil.sortStartingKElement(entries, comparator, category.start, category.end, effLimit);
                ++i;
            }
        } else {
            int effLimit = limit;
            if (entries.length - 1 < effLimit || limit == -1) {
                effLimit = entries.length - 1;
            }
            MarkerSortUtil.sortStartingKElement(entries, this.getComparator(), effLimit);
        }
        monitor.worked(50);
        newMarkers.clearAttributeCaches();
        this.currentMap = newMarkers;
    }

    MarkerCategory[] groupIntoCategories(IProgressMonitor monitor, MarkerMap newMarkers) {
        Map boundaryInfoMap = this.groupMarkerEntries(newMarkers.toArray(), this.getCategoryGroup(), newMarkers.getSize() - 1);
        Iterator iterator = boundaryInfoMap.keySet().iterator();
        int start = 0;
        MarkerCategory[] markerCategories = new MarkerCategory[boundaryInfoMap.size()];
        int i = 0;
        int end = 0;
        while (iterator.hasNext()) {
            Object key = iterator.next();
            end = (Integer)boundaryInfoMap.get(key);
            markerCategories[i++] = new MarkerCategory(this, start, end, this.getCategoryGroup().getMarkerField().getValue(newMarkers.elementAt(start)));
            start = end + 1;
        }
        return markerCategories;
    }

    Map groupMarkerEntries(MarkerEntry[] entries, MarkerGroup group, int k) {
        ArrayList<MarkerEntry> list;
        TreeMap<MarkerGroupingEntry, Serializable> map = new TreeMap<MarkerGroupingEntry, Serializable>(group.getEntriesComparator());
        int i = 0;
        while (i <= k) {
            IMarker marker = entries[i].getMarker();
            if (marker != null && marker.exists()) {
                try {
                    MarkerGroupingEntry groupingEntry = group.findGroupValue(marker.getType(), marker);
                    list = (List)map.get(groupingEntry);
                    if (list == null) {
                        list = new ArrayList<MarkerEntry>();
                        map.put(groupingEntry, list);
                    }
                    list.add(entries[i]);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        Iterator keys = map.keySet().iterator();
        int i2 = 0;
        while (keys.hasNext()) {
            Object key = keys.next();
            list = (ArrayList<MarkerEntry>)map.get(key);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MarkerEntry entry = (MarkerEntry)iterator.next();
                entries[i2++] = entry;
            }
            map.put((MarkerGroupingEntry)key, new Integer(i2 - 1));
        }
        return map;
    }

    void toggleFilter(MarkerFieldFilterGroup group) {
        Collection enabled = this.getEnabledFilters();
        if (enabled.remove(group)) {
            group.setEnabled(false);
        } else {
            group.setEnabled(true);
            enabled.add(group);
        }
        this.writeFiltersPreference();
        this.scheduleMarkerUpdate();
    }

    void updateFocusElements(Object[] elements) {
        ArrayList<Object> resourceCollection = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IResource) {
                resourceCollection.add(elements[i]);
            } else {
                this.addResources(resourceCollection, (ResourceMapping)elements[i]);
            }
            ++i;
        }
        this.focusResources = new IResource[resourceCollection.size()];
        resourceCollection.toArray(this.focusResources);
    }

    void updateForNewSelection(Object[] newElements) {
        if (this.updateNeeded(newElements)) {
            this.updateFocusElements(newElements);
            this.scheduleMarkerUpdate();
        }
    }

    void updateFrom(FiltersConfigurationDialog dialog) {
        this.setAndFilters(dialog.andFilters());
        this.filters = dialog.getFilters();
        this.enabledFilters = null;
        this.writeFiltersPreference();
        this.scheduleMarkerUpdate();
    }

    boolean updateNeeded(Object[] newElements) {
        Iterator filters = this.getEnabledFilters().iterator();
        while (filters.hasNext()) {
            MarkerFieldFilterGroup filter = (MarkerFieldFilterGroup)filters.next();
            int scope = filter.getScope();
            if (scope == 0 || scope == 4 || newElements == null || newElements.length < 1) continue;
            if (this.focusResources.length == 0) {
                return true;
            }
            if (Arrays.equals(this.focusResources, newElements)) continue;
            if (scope == 3) {
                Collection oldProjects = MarkerFieldFilterGroup.getProjectsAsCollection(this.focusResources);
                Collection newProjects = MarkerFieldFilterGroup.getProjectsAsCollection(newElements);
                if (oldProjects.size() == newProjects.size() && newProjects.containsAll(oldProjects)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void writeFiltersPreference() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_FILTERS_SECTION);
        this.writeFiltersSettings(memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.getDefault().getLog().log(Util.errorStatus(e));
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().putValue(this.getMementoPreferenceName(), writer.toString());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
    }

    private void writeFiltersSettings(XMLMemento memento) {
        memento.putBoolean(TAG_AND, this.andFilters);
        Iterator groups = this.getAllFilters().iterator();
        while (groups.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)groups.next();
            IMemento child = memento.createChild(TAG_GROUP_ENTRY, group.getID());
            group.saveFilterSettings(child);
        }
    }

    void setVisibleFields(Collection visible) {
        MarkerField[] newFields = new MarkerField[visible.size()];
        visible.toArray(newFields);
        this.visibleFields = newFields;
    }
}

