/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryCompletionProcessor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskHyperlinkDetector;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskRelationHyperlinkDetector;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskUrlHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlinkPresenter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class RepositoryTextViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final String ID_CONTEXT_EDITOR_TASK = "org.eclipse.mylyn.tasks.ui.TaskEditor";
    private static final String ID_CONTEXT_EDITOR_TEXT = "org.eclipse.ui.DefaultTextEditor";
    private RepositoryTextScanner scanner;
    private final boolean spellCheck;
    private final TaskRepository taskRepository;
    private Mode mode;

    public RepositoryTextViewerConfiguration(TaskRepository taskRepository, boolean spellCheck) {
        super(EditorsUI.getPreferenceStore());
        this.taskRepository = taskRepository;
        this.spellCheck = spellCheck;
        this.mode = Mode.DEFAULT;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.getMode() == Mode.DEFAULT) {
            PresentationReconciler reconciler = new PresentationReconciler();
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            return reconciler;
        }
        return super.getPresentationReconciler(sourceViewer);
    }

    private RepositoryTextScanner getDefaultScanner() {
        if (this.scanner == null) {
            this.scanner = new RepositoryTextScanner(this.getMode());
        }
        return this.scanner;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (this.mode == Mode.URL || this.mode == Mode.TASK_RELATION) {
            return this.getDefaultHyperlinkDetectors(sourceViewer, this.mode);
        }
        return super.getHyperlinkDetectors(sourceViewer);
    }

    public IHyperlinkDetector[] getDefaultHyperlinkDetectors(ISourceViewer sourceViewer, Mode mode) {
        IHyperlinkDetector[] detectors = mode == Mode.URL ? new IHyperlinkDetector[]{new TaskUrlHyperlinkDetector()} : (mode == Mode.TASK ? new IHyperlinkDetector[]{new TaskHyperlinkDetector()} : (mode == Mode.TASK_RELATION ? new IHyperlinkDetector[]{new TaskRelationHyperlinkDetector()} : super.getHyperlinkDetectors(sourceViewer)));
        if (detectors != null) {
            IAdaptable target = this.getDefaultHyperlinkTarget();
            IHyperlinkDetector[] iHyperlinkDetectorArray = detectors;
            int n = detectors.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlinkDetector hyperlinkDetector = iHyperlinkDetectorArray[n2];
                if (hyperlinkDetector instanceof AbstractHyperlinkDetector) {
                    ((AbstractHyperlinkDetector)hyperlinkDetector).setContext(target);
                }
                ++n2;
            }
        }
        return detectors;
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        IAdaptable context = this.getDefaultHyperlinkTarget();
        HashMap<String, IAdaptable> targets = new HashMap<String, IAdaptable>();
        targets.put(ID_CONTEXT_EDITOR_TEXT, context);
        targets.put(ID_CONTEXT_EDITOR_TASK, context);
        return targets;
    }

    private IAdaptable getDefaultHyperlinkTarget() {
        IAdaptable context = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter == TaskRepository.class) {
                    return RepositoryTextViewerConfiguration.this.getTaskRepository();
                }
                return null;
            }
        };
        return context;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return new TaskHyperlinkPresenter(new RGB(0, 0, 255));
        }
        return new TaskHyperlinkPresenter(this.fPreferenceStore);
    }

    public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
        return 0;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.spellCheck) {
            return super.getReconciler(sourceViewer);
        }
        return null;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.mode == Mode.URL) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        RepositoryCompletionProcessor processor = new RepositoryCompletionProcessor(this.taskRepository);
        if (this.mode == Mode.TASK_RELATION) {
            processor.setNeverIncludePrefix(true);
        }
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        return assistant;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        URL,
        TASK,
        TASK_RELATION,
        DEFAULT;

    }

    private static class RepositoryTextScanner
    extends RuleBasedScanner {
        public RepositoryTextScanner(Mode mode) {
            Token bugToken = new Token((Object)new TextAttribute(JFaceResources.getColorRegistry().get("ACTIVE_HYPERLINK_COLOR")));
            Token quoteToken = new Token((Object)new TextAttribute(CommonColors.TEXT_QUOTED));
            IRule[] rules = new IRule[16];
            rules[0] = new SingleLineRule("http://", " ", (IToken)bugToken);
            rules[1] = new SingleLineRule("https://", " ", (IToken)bugToken);
            rules[2] = new SingleLineRule("bug#", " ", (IToken)bugToken);
            rules[3] = new SingleLineRule("bug#", "", (IToken)bugToken);
            rules[4] = new SingleLineRule("bug #", "", (IToken)bugToken);
            rules[5] = new SingleLineRule("http://", "\n", (IToken)bugToken);
            rules[6] = new SingleLineRule("https://", "\n", (IToken)bugToken);
            rules[7] = new SingleLineRule("task#", " ", (IToken)bugToken);
            rules[8] = new MultiLineRule("task#", "\n", (IToken)bugToken);
            rules[9] = new MultiLineRule("task# ", " ", (IToken)bugToken);
            rules[10] = new SingleLineRule("task #", "\n", (IToken)bugToken);
            rules[11] = new SingleLineRule("*** This bug has been ", "***", (IToken)bugToken);
            rules[12] = new SingleLineRule("http://", "", (IToken)bugToken);
            rules[13] = new SingleLineRule("https://", "", (IToken)bugToken);
            rules[14] = new MultiLineRule("task #", " ", (IToken)bugToken);
            SingleLineRule quoteRule = new SingleLineRule(">", null, (IToken)quoteToken, '\u0000', true);
            quoteRule.setColumnConstraint(0);
            rules[15] = quoteRule;
            this.setRules(rules);
        }
    }
}

