/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TaskAttachmentStorage
extends PlatformObject
implements IStorage {
    private static final String ATTACHMENT_DEFAULT_NAME = "attachment";
    private static final String CTYPE_ZIP = "zip";
    private static final String CTYPE_OCTET_STREAM = "octet-stream";
    private static final String CTYPE_TEXT = "text";
    private static final String CTYPE_HTML = "html";
    private final TaskRepository taskRepository;
    private final ITask task;
    private final TaskAttribute attachmentAttribute;
    private final String name;

    public TaskAttachmentStorage(TaskRepository taskRepository, ITask task, TaskAttribute attachmentAttribute, String name) {
        this.taskRepository = taskRepository;
        this.task = task;
        this.attachmentAttribute = attachmentAttribute;
        this.name = name;
    }

    public static IStorage create(ITaskAttachment attachment) throws CoreException {
        Assert.isNotNull((Object)attachment);
        TaskAttribute taskAttribute = attachment.getTaskAttribute();
        if (taskAttribute == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to find attachment: " + attachment.getUrl()));
        }
        return new TaskAttachmentStorage(attachment.getTaskRepository(), attachment.getTask(), taskAttribute, TaskAttachmentStorage.getName(attachment));
    }

    private static String getName(ITaskAttachment attachment) {
        String name = attachment.getFileName();
        if (name == null || "".equals(name)) {
            String ctype = attachment.getContentType();
            name = ctype.endsWith(CTYPE_HTML) ? "attachment.html" : (ctype.startsWith(CTYPE_TEXT) ? "attachment.txt" : (ctype.endsWith(CTYPE_OCTET_STREAM) ? ATTACHMENT_DEFAULT_NAME : (ctype.endsWith(CTYPE_ZIP) ? "attachment.zip" : "attachment." + ctype.substring(ctype.indexOf("/") + 1))));
        }
        if (name.endsWith(".patch")) {
            name = String.valueOf(name) + ".txt";
        }
        return name;
    }

    public InputStream getContents() throws CoreException {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.taskRepository.getConnectorKind());
        AbstractTaskAttachmentHandler handler = connector.getTaskAttachmentHandler();
        return handler.getContent(this.taskRepository, this.task, this.attachmentAttribute, (IProgressMonitor)new NullProgressMonitor());
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return true;
    }
}

