/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIBreakpointMovedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIBreakpointProblemEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassemblyInstruction;
import org.eclipse.cdt.debug.core.model.IDisassemblyLine;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.DisassemblyInstruction;
import org.eclipse.cdt.debug.internal.core.model.DisassemblySourceLine;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;

public class DisassemblyRetrieval
extends CDebugElement
implements ICDIEventListener {
    public static final int FLAGS_SHOW_INSTRUCTIONS = 1;
    public static final int FLAGS_SHOW_SOURCE = 2;
    private Object fInput = null;
    private BigInteger fBaseElement = null;
    private int fCurrentOffset = 0;
    private int fFlags = 0;
    private IDisassemblyLine[] fLines = new IDisassemblyLine[0];

    public DisassemblyRetrieval(CDebugTarget target) {
        super(target);
        CDebugCorePlugin.getDefault().getDisassemblyContextService().register(this);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public void dispose() {
        this.getCDISession().getEventManager().removeEventListener(this);
        CDebugCorePlugin.getDefault().getDisassemblyContextService().unregister(this);
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        ICDIEvent[] iCDIEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            BigInteger address;
            ICDIEvent event = iCDIEventArray[n2];
            ICDIObject source = event.getSource();
            if ((event instanceof ICDICreatedEvent || event instanceof ICDIChangedEvent || event instanceof ICDIDestroyedEvent || event instanceof ICDIBreakpointMovedEvent || event instanceof ICDIBreakpointProblemEvent) && source instanceof ICDILocationBreakpoint && (address = ((ICDILocationBreakpoint)source).getLocator().getAddress()) != null) {
                int index = this.getIndexForAddress(address, this.fLines);
                if (index >= 0) {
                    this.fireEvent(new DebugEvent((Object)this.fLines[index], 16, 256));
                }
                if (event instanceof ICDIBreakpointMovedEvent && (address = ((ICDIBreakpointMovedEvent)event).getNewLocation().getAddress()) != null && (index = this.getIndexForAddress(address, this.fLines)) >= 0) {
                    this.fireEvent(new DebugEvent((Object)this.fLines[index], 16, 256));
                }
            }
            ++n2;
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    public BigInteger getBaseElement() {
        return this.fBaseElement;
    }

    public int getCurrentOffset() {
        return this.fCurrentOffset;
    }

    public IDisassemblyLine[] getLines() {
        return this.fLines;
    }

    public void changeBase(Object input, int offset, int flags) throws DebugException {
        if (input instanceof ICStackFrame) {
            this.fInput = input;
            ICStackFrame frame = (ICStackFrame)input;
            BigInteger address = frame.getAddress().getValue();
            if (!this.containsAddress(address, this.fLines)) {
                this.fCurrentOffset = 0;
                this.reset();
            } else if (flags != this.fFlags) {
                this.reset();
            } else {
                this.fCurrentOffset += this.getDistance(this.fBaseElement, address);
            }
            this.fFlags = flags;
            this.fBaseElement = address;
        }
    }

    public void retrieveDisassembly(Object input, Object base, int offset, int lineCount, boolean reveal, int flags) throws DebugException {
        this.fFlags = flags;
        boolean showSource = (flags & 2) != 0;
        ArrayList<IDisassemblyLine> lines = new ArrayList<IDisassemblyLine>(lineCount);
        BigInteger startAddress = this.getCurrentStartAddress();
        BigInteger address = null;
        if (startAddress != null) {
            if (this.getCurrentOffset() > offset) {
                address = startAddress.subtract(BigInteger.valueOf(this.getMinInstructionSize() * (this.getCurrentOffset() - offset)));
            } else if (this.getCurrentOffset() < offset) {
                IDisassemblyInstruction next = this.getNextInstruction(startAddress, this.fLines);
                if (next != null) {
                    address = next.getAdress().getValue();
                }
            } else {
                address = startAddress;
            }
        }
        if (address == null) {
            address = this.fBaseElement;
        }
        lines.addAll(Arrays.asList(this.disassembleDown(address, lineCount, showSource)));
        this.fLines = lines.toArray(new IDisassemblyLine[lines.size()]);
        this.fCurrentOffset = offset;
    }

    private boolean containsAddress(BigInteger address, IDisassemblyLine[] lines) {
        return this.getIndexForAddress(address, lines) >= 0;
    }

    public void reset() {
        this.fLines = new IDisassemblyLine[0];
    }

    private int getDistance(BigInteger address1, BigInteger address2) {
        int index1 = this.getIndexForAddress(address1, this.fLines);
        Assert.isTrue((index1 >= 0 ? 1 : 0) != 0);
        int index2 = this.getIndexForAddress(address2, this.fLines);
        Assert.isTrue((index2 >= 0 ? 1 : 0) != 0);
        return index2 - index1;
    }

    private int getIndexForAddress(BigInteger address, IDisassemblyLine[] lines) {
        int i = 0;
        while (i < lines.length) {
            if (lines[i] instanceof IDisassemblyInstruction && address.compareTo(((IDisassemblyInstruction)lines[i]).getAdress().getValue()) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private BigInteger getCurrentStartAddress() {
        IDisassemblyLine[] iDisassemblyLineArray = this.fLines;
        int n = this.fLines.length;
        int n2 = 0;
        while (n2 < n) {
            IDisassemblyLine l = iDisassemblyLineArray[n2];
            if (l instanceof IDisassemblyInstruction) {
                return ((IDisassemblyInstruction)l).getAdress().getValue();
            }
            ++n2;
        }
        return null;
    }

    private IDisassemblyLine[] disassembleDown(BigInteger address, int lineCount, boolean mixed) throws DebugException {
        BigInteger startAddress = address;
        IDisassemblyLine[] lines = new IDisassemblyLine[]{};
        BigInteger endAddress = startAddress;
        if (lines.length < lineCount && endAddress.compareTo(this.getGlobalEndAddress()) < 0) {
            endAddress = address.add(BigInteger.valueOf(lineCount * this.getMaxInstructionSize()));
            if (endAddress.compareTo(this.getGlobalEndAddress()) > 0) {
                endAddress = this.getGlobalEndAddress();
            }
            lines = this.disassemble(address, endAddress, mixed);
            IDisassemblyInstruction firstInstruction = this.getFirstInstruction(lines);
            IDisassemblyInstruction lastInstruction = this.getLastInstruction(lines);
            if (firstInstruction != null && lastInstruction != null) {
                if (startAddress.compareTo(firstInstruction.getAdress().getValue()) < 0) {
                    lines = this.appendLines(this.disassemble(startAddress, firstInstruction.getAdress().getValue(), mixed), lines);
                }
                if ((startAddress = lastInstruction.getAdress().getValue()).compareTo(endAddress) < 0) {
                    IDisassemblyLine[] extraLines = new IDisassemblyLine[]{};
                    while (extraLines.length == 0 && endAddress.compareTo(this.getGlobalEndAddress()) < 0) {
                        endAddress = endAddress.add(BigInteger.valueOf(this.getMaxInstructionSize()));
                        extraLines = this.disassemble(startAddress, endAddress, mixed);
                    }
                    lines = this.appendLines(lines, extraLines);
                }
            }
        }
        int size = Math.min(lineCount, lines.length);
        IDisassemblyLine[] result = new IDisassemblyLine[size];
        int start = this.getIndexForAddress(address, lines);
        if (start != -1) {
            System.arraycopy(lines, start, result, 0, size);
        }
        return result;
    }

    private IDisassemblyLine[] disassemble(BigInteger startAddress, BigInteger endAddress, boolean mixed) throws DebugException {
        ArrayList<CDebugElement> list = new ArrayList<CDebugElement>();
        ICDITarget cdiTarget = (ICDITarget)this.getDebugTarget().getAdapter(ICDITarget.class);
        try {
            ICDIMixedInstruction[] mixedInstructions = null;
            ICDIInstruction[] asmInstructions = null;
            if (mixed && ((mixedInstructions = cdiTarget.getMixedInstructions(startAddress, endAddress)).length == 0 || mixedInstructions.length == 1 && mixedInstructions[0].getInstructions().length == 0)) {
                mixedInstructions = null;
            }
            if (mixedInstructions == null) {
                asmInstructions = cdiTarget.getInstructions(startAddress, endAddress);
            }
            if (mixedInstructions != null) {
                ICDIMixedInstruction[] iCDIMixedInstructionArray = mixedInstructions;
                int n = mixedInstructions.length;
                int n2 = 0;
                while (n2 < n) {
                    ICDIMixedInstruction mi = iCDIMixedInstructionArray[n2];
                    ICDIInstruction[] instructions = mi.getInstructions();
                    if (instructions.length > 0) {
                        list.add(new DisassemblySourceLine((CDebugTarget)this.getDebugTarget(), this.fBaseElement, mi));
                        ICDIInstruction[] iCDIInstructionArray = instructions;
                        int n3 = instructions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICDIInstruction i = iCDIInstructionArray[n4];
                            list.add(new DisassemblyInstruction((CDebugTarget)this.getDebugTarget(), this.fBaseElement, i));
                            ++n4;
                        }
                    }
                    ++n2;
                }
            } else if (asmInstructions != null) {
                ICDIInstruction[] iCDIInstructionArray = asmInstructions;
                int n = asmInstructions.length;
                int n5 = 0;
                while (n5 < n) {
                    ICDIInstruction i = iCDIInstructionArray[n5];
                    list.add(new DisassemblyInstruction((CDebugTarget)this.getDebugTarget(), this.fBaseElement, i));
                    ++n5;
                }
            }
        }
        catch (CDIException exc) {
            throw new DebugException((IStatus)new Status(4, "dummy", exc.getDetailMessage(), (Throwable)exc));
        }
        return list.toArray(new IDisassemblyLine[list.size()]);
    }

    private int getMaxInstructionSize() {
        return 4;
    }

    private int getMinInstructionSize() {
        return 1;
    }

    private IDisassemblyInstruction getNextInstruction(BigInteger address, IDisassemblyLine[] lines) {
        int index = this.getIndexForAddress(address, lines);
        if (index == -1 || index == lines.length - 1) {
            return null;
        }
        int i = index + 1;
        while (i < lines.length) {
            if (lines[i] instanceof IDisassemblyInstruction) {
                return (IDisassemblyInstruction)lines[i];
            }
            ++i;
        }
        return null;
    }

    private IDisassemblyInstruction getPreviousInstruction(BigInteger baseAddress) throws DebugException {
        BigInteger endAddress = baseAddress.add(BigInteger.valueOf(1L));
        BigInteger startAddress = baseAddress;
        IDisassemblyLine[] lines = new IDisassemblyLine[]{};
        int index = -1;
        while (index == -1 && startAddress.compareTo(this.getGlobalStartAddress()) > 0) {
            startAddress = startAddress.subtract(BigInteger.valueOf(1L));
            lines = this.disassemble(startAddress, endAddress, false);
            index = this.getIndexForAddress(baseAddress, lines);
        }
        return index > 0 ? (IDisassemblyInstruction)lines[index - 1] : null;
    }

    private IDisassemblyInstruction getFirstInstruction(IDisassemblyLine[] lines) {
        IDisassemblyLine[] iDisassemblyLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            IDisassemblyLine l = iDisassemblyLineArray[n2];
            if (l instanceof IDisassemblyInstruction) {
                return (IDisassemblyInstruction)l;
            }
            ++n2;
        }
        return null;
    }

    private IDisassemblyInstruction getLastInstruction(IDisassemblyLine[] lines) {
        int i = lines.length - 1;
        while (i >= 0) {
            if (lines[i] instanceof IDisassemblyInstruction) {
                return (IDisassemblyInstruction)lines[i];
            }
            --i;
        }
        return null;
    }

    private BigInteger getGlobalStartAddress() {
        return this.getAddressFactory().getZero().getValue();
    }

    private BigInteger getGlobalEndAddress() {
        return this.getAddressFactory().getMax().getValue();
    }

    private IAddressFactory getAddressFactory() {
        return ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
    }

    private IDisassemblyLine[] appendLines(IDisassemblyLine[] lines1, IDisassemblyLine[] lines2) {
        ArrayList<IDisassemblyLine> list = new ArrayList<IDisassemblyLine>(lines1.length + lines2.length);
        list.addAll(Arrays.asList(lines1));
        IDisassemblyLine[] iDisassemblyLineArray = lines2;
        int n = lines2.length;
        int n2 = 0;
        while (n2 < n) {
            IDisassemblyLine l = iDisassemblyLineArray[n2];
            if (!list.contains(l)) {
                list.add(l);
            }
            ++n2;
        }
        return list.toArray(new IDisassemblyLine[list.size()]);
    }
}

