/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.cdt.debug.internal.core.CBreakpointManager;
import org.eclipse.cdt.debug.internal.core.ListenerList;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;

public class CSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private static final NoSourceElement gfNoSource = new NoSourceElement();
    private ListenerList fListeners = new ListenerList(1);
    private ISourceContainer[] containers;

    public String getSourceName(Object object) throws CoreException {
        ICStackFrame frame;
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IAdaptable && (frame = (ICStackFrame)((IAdaptable)object).getAdapter(ICStackFrame.class)) != null) {
            String name = frame.getFile();
            return name != null && name.trim().length() > 0 ? name : null;
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] foundElements;
        this.initContainersSourceDirector();
        String name = null;
        IBreakpoint breakpoint = null;
        if (object instanceof IAdaptable) {
            ICStackFrame frame = (ICStackFrame)((IAdaptable)object).getAdapter(ICStackFrame.class);
            if (frame != null && ((name = frame.getFile().trim()) == null || name.length() == 0)) {
                if (object instanceof IDebugElement) {
                    return new Object[]{new CSourceNotFoundElement((IDebugElement)object)};
                }
                return new Object[]{gfNoSource};
            }
            ICDebugTarget target = (ICDebugTarget)((IAdaptable)object).getAdapter(ICDebugTarget.class);
            if (target != null) {
                CBreakpointManager bmanager = (CBreakpointManager)target.getAdapter(CBreakpointManager.class);
                Object stateInfo = target.getCurrentStateInfo();
                if (bmanager != null && stateInfo instanceof ICDIBreakpointHit) {
                    breakpoint = bmanager.getBreakpoint(((ICDIBreakpointHit)stateInfo).getBreakpoint());
                }
            }
        } else if (object instanceof String) {
            name = (String)object;
        }
        if ((foundElements = super.findSourceElements(object)).length == 0 && object instanceof IDebugElement) {
            foundElements = new File(name).exists() ? new AbsolutePathSourceContainer().findSourceElements(name) : new Object[]{new CSourceNotFoundElement((IDebugElement)object)};
        }
        if (breakpoint != null && breakpoint.getMarker() != null && breakpoint.getMarker().getResource() != null) {
            IResource breakpointResource = breakpoint.getMarker().getResource();
            int i = 0;
            while (i < foundElements.length) {
                if (foundElements[i].equals(breakpointResource)) {
                    Object temp = foundElements[0];
                    foundElements[0] = foundElements[i];
                    foundElements[i] = temp;
                    break;
                }
                ++i;
            }
        }
        this.endContainersSourceDirector();
        return foundElements;
    }

    public boolean isFindDuplicates() {
        return true;
    }

    public void dispose() {
        this.fListeners.removeAll();
        super.dispose();
    }

    public void addSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISourceLookupChangeListener)listeners[i]).sourceContainersChanged(director);
            ++i;
        }
        super.sourceContainersChanged(director);
    }

    private void initContainersSourceDirector() {
        ISourceLookupDirector dummySourceDirector = new ISourceLookupDirector(){

            public void addParticipants(ISourceLookupParticipant[] participants) {
                CSourceLookupParticipant.this.getDirector().addParticipants(participants);
            }

            public void clearSourceElements(Object element) {
                CSourceLookupParticipant.this.getDirector().clearSourceElements(element);
            }

            public Object[] findSourceElements(Object object) throws CoreException {
                return CSourceLookupParticipant.this.getDirector().findSourceElements(object);
            }

            public String getId() {
                return CSourceLookupParticipant.this.getDirector().getId();
            }

            public ILaunchConfiguration getLaunchConfiguration() {
                return CSourceLookupParticipant.this.getDirector().getLaunchConfiguration();
            }

            public ISourceLookupParticipant[] getParticipants() {
                return CSourceLookupParticipant.this.getDirector().getParticipants();
            }

            public ISourceContainer[] getSourceContainers() {
                return CSourceLookupParticipant.this.getDirector().getSourceContainers();
            }

            public Object getSourceElement(Object element) {
                return CSourceLookupParticipant.this.getDirector().getSourceElement(element);
            }

            public ISourcePathComputer getSourcePathComputer() {
                return CSourceLookupParticipant.this.getDirector().getSourcePathComputer();
            }

            public void initializeParticipants() {
                CSourceLookupParticipant.this.getDirector().initializeParticipants();
            }

            public boolean isFindDuplicates() {
                return CSourceLookupParticipant.this.isFindDuplicates();
            }

            public void removeParticipants(ISourceLookupParticipant[] participants) {
                CSourceLookupParticipant.this.getDirector().removeParticipants(participants);
            }

            public void setFindDuplicates(boolean findDuplicates) {
                CSourceLookupParticipant.this.getDirector().setFindDuplicates(findDuplicates);
            }

            public void setSourceContainers(ISourceContainer[] containers) {
                CSourceLookupParticipant.this.getDirector().setSourceContainers(containers);
            }

            public void setSourcePathComputer(ISourcePathComputer computer) {
                CSourceLookupParticipant.this.getDirector().setSourcePathComputer(computer);
            }

            public boolean supportsSourceContainerType(ISourceContainerType type) {
                return CSourceLookupParticipant.this.getDirector().supportsSourceContainerType(type);
            }

            public void dispose() {
                CSourceLookupParticipant.this.getDirector().dispose();
            }

            public void initializeFromMemento(String memento, ILaunchConfiguration configuration) throws CoreException {
                CSourceLookupParticipant.this.getDirector().initializeFromMemento(memento, configuration);
            }

            public String getMemento() throws CoreException {
                return CSourceLookupParticipant.this.getDirector().getMemento();
            }

            public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
                CSourceLookupParticipant.this.getDirector().initializeDefaults(configuration);
            }

            public void initializeFromMemento(String memento) throws CoreException {
                CSourceLookupParticipant.this.getDirector().initializeFromMemento(memento);
            }

            public Object getSourceElement(IStackFrame stackFrame) {
                return CSourceLookupParticipant.this.getDirector().getSourceElement(stackFrame);
            }
        };
        ISourceContainer[] iSourceContainerArray = this.containers = this.getSourceContainers();
        int n = this.containers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer cont = iSourceContainerArray[n2];
            cont.init(dummySourceDirector);
            ++n2;
        }
    }

    private void endContainersSourceDirector() {
        if (this.containers != null) {
            ISourceContainer[] iSourceContainerArray = this.containers;
            int n = this.containers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer cont = iSourceContainerArray[n2];
                cont.init(this.getDirector());
                ++n2;
            }
        }
        this.containers = null;
    }

    static class NoSourceElement {
        NoSourceElement() {
        }
    }
}

