/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class BugzillaAttachmentMapper
extends TaskAttachmentMapper {
    private String token;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void applyTo(TaskAttribute taskAttribute) {
        super.applyTo(taskAttribute);
        Assert.isNotNull((Object)taskAttribute);
        TaskData taskData = taskAttribute.getTaskData();
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        if (this.getToken() != null) {
            TaskAttribute child = taskAttribute.createMappedAttribute(BugzillaAttribute.TOKEN.getKey());
            child.getMetaData().defaults().setType("shortText");
            mapper.setValue(child, this.getToken());
        }
    }

    public static BugzillaAttachmentMapper createFrom(TaskAttribute taskAttribute) {
        Long value;
        Assert.isNotNull((Object)taskAttribute);
        TaskAttributeMapper mapper = taskAttribute.getTaskData().getAttributeMapper();
        BugzillaAttachmentMapper attachment = new BugzillaAttachmentMapper();
        attachment.setAttachmentId(mapper.getValue(taskAttribute));
        TaskAttribute child = taskAttribute.getMappedAttribute("task.common.attachment.author");
        if (child != null) {
            attachment.setAuthor(mapper.getRepositoryPerson(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.ctype")) != null) {
            attachment.setContentType(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.date")) != null) {
            attachment.setCreationDate(mapper.getDateValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.description")) != null) {
            attachment.setDescription(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("filename")) != null) {
            attachment.setFileName(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.deprecated")) != null) {
            attachment.setDeprecated(mapper.getBooleanValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.patch")) != null) {
            attachment.setPatch(mapper.getBooleanValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.size")) != null && (value = mapper.getLongValue(child)) != null) {
            attachment.setLength(value);
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.url")) != null) {
            attachment.setUrl(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute(BugzillaAttribute.TOKEN.getKey())) != null) {
            attachment.setToken(mapper.getValue(child));
        }
        return attachment;
    }

    public static /* bridge */ /* synthetic */ TaskAttachmentMapper createFrom(TaskAttribute taskAttribute) {
        return BugzillaAttachmentMapper.createFrom(taskAttribute);
    }
}

