/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.AddressRangePosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.LabelPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.SourcePosition;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;

public class DisassemblyTextHover
implements ITextHover {
    private final DisassemblyPart fDisassemblyPart;

    public DisassemblyTextHover(DisassemblyPart part) {
        this.fDisassemblyPart = part;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument doc = textViewer.getDocument();
        return CWordFinder.findWord((IDocument)doc, (int)offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block8: {
            DisassemblyDocument doc = (DisassemblyDocument)textViewer.getDocument();
            int offset = hoverRegion.getOffset();
            try {
                String ident = doc.get(offset, hoverRegion.getLength());
                String value = null;
                AddressRangePosition pos = doc.getModelPosition(offset);
                if (pos instanceof SourcePosition) {
                    value = this.evaluateExpression(ident);
                } else if (pos instanceof LabelPosition) {
                    value = this.evaluateExpression(ident);
                } else if (pos instanceof DisassemblyPosition && (value = this.evaluateRegister(ident)) == null) {
                    value = this.evaluateExpression(ident);
                }
                if (value != null) {
                    return String.valueOf(ident) + " = " + value;
                }
            }
            catch (BadLocationException e) {
                if (!DsfUIPlugin.getDefault().isDebugging()) break block8;
                DsfUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", "Internal Error", (Throwable)e));
            }
        }
        return null;
    }

    private String evaluateRegister(String register) {
        return null;
    }

    private String evaluateExpression(final String expr) {
        final IStack.IFrameDMContext frameDmc = this.fDisassemblyPart.getTargetFrameContext();
        if (frameDmc == null) {
            return null;
        }
        final DsfExecutor executor = this.fDisassemblyPart.getSession().getExecutor();
        Query<IFormattedValues.FormattedValueDMData> query = new Query<IFormattedValues.FormattedValueDMData>(){

            protected void execute(final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
                IRunControl.IExecutionDMContext exeCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frameDmc, IRunControl.IExecutionDMContext.class);
                IRunControl rc = DisassemblyTextHover.this.fDisassemblyPart.getService(IRunControl.class);
                if (rc == null || !rc.isSuspended(exeCtx)) {
                    rm.done();
                    return;
                }
                IExpressions expressions = DisassemblyTextHover.this.fDisassemblyPart.getService(IExpressions.class);
                if (expressions == null) {
                    rm.done();
                    return;
                }
                IExpressions.IExpressionDMContext exprDmc = expressions.createExpression((IDMContext)frameDmc, expr);
                IFormattedValues.FormattedValueDMContext valueDmc = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format");
                expressions.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)executor, rm){

                    protected void handleSuccess() {
                        IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)this.getData();
                        rm.setData((Object)data);
                        rm.done();
                    }
                });
            }
        };
        executor.execute((Runnable)query);
        IFormattedValues.FormattedValueDMData data = null;
        try {
            data = (IFormattedValues.FormattedValueDMData)query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        if (data != null) {
            return data.getFormattedValue();
        }
        return null;
    }
}

