/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.actions.BlockCommentAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddBlockCommentAction
extends BlockCommentAction {
    public AddBlockCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    @Override
    protected void runInternal(ITextSelection selection, IDocumentExtension3 docExtension, BlockCommentAction.Edit.EditFactory factory) throws BadLocationException, BadPartitioningException {
        if (!(docExtension instanceof IDocument)) {
            return;
        }
        LinkedList<BlockCommentAction.Edit> edits = new LinkedList<BlockCommentAction.Edit>();
        ITypedRegion firstPartition = docExtension.getPartition("___c_partitioning", selection.getOffset(), false);
        ITypedRegion lastPartition = docExtension.getPartition("___c_partitioning", selection.getOffset() + selection.getLength() - 1, false);
        int commentAreaStart = selection.getOffset();
        int commentAreaEnd = selection.getOffset() + selection.getLength();
        if (this.isSpecialPartition(firstPartition.getType())) {
            commentAreaStart = firstPartition.getOffset();
        }
        if (this.isSpecialPartition(lastPartition.getType())) {
            commentAreaEnd = lastPartition.getOffset() + lastPartition.getLength();
        }
        Region estimatedCommentArea = new Region(commentAreaStart, commentAreaEnd - commentAreaStart);
        Region commentArea = this.handleEnclosingPartitions(estimatedCommentArea, lastPartition, (IDocument)docExtension, factory, edits);
        this.handleInteriorPartition((IRegion)commentArea, firstPartition, docExtension, factory, edits);
        this.executeEdits(edits);
    }

    private Region handleEnclosingPartitions(Region commentArea, ITypedRegion lastPartition, IDocument doc, BlockCommentAction.Edit.EditFactory factory, List<BlockCommentAction.Edit> edits) throws BadLocationException {
        String endLineEOL;
        int commentAreaStart = commentArea.getOffset();
        int commentAreaEnd = commentArea.getOffset() + commentArea.getLength();
        String commentStartTag = this.getCommentStart();
        String commentEndTag = this.getCommentEnd();
        String startLineEOL = doc.getLineDelimiter(doc.getLineOfOffset(commentAreaStart));
        if (startLineEOL == null) {
            startLineEOL = "";
        }
        if ((endLineEOL = doc.getLineDelimiter(doc.getLineOfOffset(commentAreaEnd - 1))) == null) {
            endLineEOL = "";
        }
        boolean isLeftEol = commentAreaStart < startLineEOL.length() || doc.get(commentAreaStart - startLineEOL.length(), startLineEOL.length()).equals(startLineEOL);
        boolean isRightEol = doc.get(commentAreaEnd - endLineEOL.length(), endLineEOL.length()).equals(endLineEOL);
        if (isLeftEol && isRightEol) {
            int areaEndLine;
            int areaStartLine = doc.getLineOfOffset(commentAreaStart + startLineEOL.length());
            if (areaStartLine != (areaEndLine = doc.getLineOfOffset(commentAreaEnd - endLineEOL.length()))) {
                commentStartTag = String.valueOf(this.getCommentStart()) + startLineEOL;
                commentEndTag = String.valueOf(this.getCommentEnd()) + endLineEOL;
            } else {
                commentAreaEnd -= endLineEOL.length();
            }
        } else if (lastPartition.getType() == "__c_singleline_comment" || lastPartition.getType() == "__c_singleline_doc_comment") {
            commentAreaEnd -= endLineEOL.length();
        }
        edits.add(factory.createEdit(commentAreaStart, 0, commentStartTag));
        edits.add(factory.createEdit(commentAreaEnd, 0, commentEndTag));
        return new Region(commentAreaStart, commentAreaEnd - commentAreaStart);
    }

    private void handleInteriorPartition(IRegion commentArea, ITypedRegion partition, IDocumentExtension3 docExtension, BlockCommentAction.Edit.EditFactory factory, List<BlockCommentAction.Edit> edits) throws BadLocationException, BadPartitioningException {
        int commentAreaEnd = commentArea.getOffset() + commentArea.getLength();
        int prevPartitionEnd = -1;
        int partitionEnd = partition.getOffset() + partition.getLength();
        int startCommentTokenLength = this.getCommentStart().length();
        int endCommentTokenLength = this.getCommentEnd().length();
        while (partitionEnd <= commentAreaEnd) {
            if (partition.getType() == "__c_multiline_comment" || partition.getType() == "__c_multiline_doc_comment") {
                edits.add(factory.createEdit(partition.getOffset(), startCommentTokenLength, ""));
                edits.add(factory.createEdit(partitionEnd - endCommentTokenLength, endCommentTokenLength, ""));
            }
            prevPartitionEnd = partitionEnd;
            partition = docExtension.getPartition("___c_partitioning", partitionEnd, false);
            if ((partitionEnd = partition.getOffset() + partition.getLength()) <= prevPartitionEnd) break;
        }
    }

    private boolean isSpecialPartition(String partType) {
        return partType != "__dftl_partition_content_type";
    }

    @Override
    protected boolean isValidSelection(ITextSelection selection) {
        return selection != null && !selection.isEmpty() && selection.getLength() > 0;
    }
}

