/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.CUIStatus;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress {
    private IWorkspaceRunnable fWorkspaceRunnable;
    private ISchedulingRule fRule;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable) {
        this(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule) {
        this.fWorkspaceRunnable = runnable;
        this.fRule = rule;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.fRule;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            CoreModel.run((IWorkspaceRunnable)this.fWorkspaceRunnable, (ISchedulingRule)this.fRule, (IProgressMonitor)monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void runAsUserJob(String name, final Object jobFamiliy) {
        Job buildJob = new Job(name){

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        WorkbenchRunnableAdapter.this.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof CoreException) {
                            IStatus iStatus = ((CoreException)cause).getStatus();
                            monitor.done();
                            return iStatus;
                        }
                        IStatus iStatus = CUIStatus.createError(4, cause);
                        monitor.done();
                        return iStatus;
                    }
                    catch (InterruptedException interruptedException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return jobFamiliy == family;
            }
        };
        buildJob.setRule(this.fRule);
        buildJob.setUser(true);
        buildJob.schedule();
    }
}

