/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LibraryRefContainer
extends CElementGrouping {
    private Object[] EMPTY = new Object[0];
    private ICProject fCProject;

    public LibraryRefContainer(ICProject cproject) {
        super(4096);
        this.fCProject = cproject;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        if (adapter == ICProject.class) {
            return this.fCProject;
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        try {
            ILibraryReference[] references = this.fCProject.getLibraryReferences();
            ArrayList<ILibraryReference> list = new ArrayList<ILibraryReference>(references.length);
            int i = 0;
            while (i < references.length) {
                IPath path = references[i].getPath();
                IFile file = references[i].getCModel().getWorkspace().getRoot().getFileForLocation(path);
                if (file == null || !file.isAccessible()) {
                    list.add(references[i]);
                }
                ++i;
            }
            return list.toArray();
        }
        catch (CModelException cModelException) {
            return this.EMPTY;
        }
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return CPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel(Object o) {
        return CViewMessages.LibraryRefContainer_Libraries;
    }

    public Object getParent(Object o) {
        return this.getCProject();
    }

    public ICProject getCProject() {
        return this.fCProject;
    }
}

