/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.preferences.PathEntryVariableDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class PathEntryVariablesGroup {
    private static final int SIZING_SELECTION_PANE_WIDTH = 400;
    private Shell shell;
    private Label variableLabel;
    private Table variableTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private FontMetrics fontMetrics;
    private boolean multiSelect;
    private int variableType;
    protected Listener selectionListener;
    private SortedMap<String, IPath> tempPathVariables;
    private Set<String> removedVariableNames;
    private IPathEntryVariableManager pathEntryVariableManager;
    private final Image FILE_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private final Image FOLDER_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private Image imageUnkown;

    public PathEntryVariablesGroup(boolean multiSelect, int variableType) {
        this.multiSelect = multiSelect;
        this.variableType = variableType;
        this.pathEntryVariableManager = CCorePlugin.getDefault().getPathEntryVariableManager();
        this.removedVariableNames = new HashSet<String>();
        this.tempPathVariables = new TreeMap<String, IPath>();
        this.initTemporaryState();
    }

    public PathEntryVariablesGroup(boolean multiSelect, int variableType, Listener selectionListener) {
        this(multiSelect, variableType);
        this.selectionListener = selectionListener;
    }

    protected void addNewVariable() {
        PathEntryVariableDialog dialog = new PathEntryVariableDialog(this.shell, 1, this.variableType, this.tempPathVariables.keySet());
        if (dialog.open() == 1) {
            return;
        }
        String newVariableName = dialog.getVariableName();
        Path newVariableValue = new Path(dialog.getVariableValue());
        this.tempPathVariables.put(newVariableName, (IPath)newVariableValue);
        this.updateWidgetState(newVariableName);
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        if (this.imageUnkown == null) {
            ImageDescriptor descriptor = CPluginImages.DESC_OVR_WARNING;
            this.imageUnkown = descriptor.createImage();
        }
        this.initializeDialogUnits((Control)parent);
        this.shell = parent.getShell();
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        pageComponent.setLayoutData((Object)data);
        pageComponent.setFont(font);
        this.variableLabel = new Label(pageComponent, 16384);
        this.variableLabel.setText(PreferencesMessages.PathEntryVariablesBlock_variablesLabel);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.variableLabel.setLayoutData((Object)data);
        this.variableLabel.setFont(font);
        int tableStyle = 67584;
        if (this.multiSelect) {
            tableStyle |= 2;
        }
        this.variableTable = new Table(pageComponent, tableStyle);
        this.variableTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEntryVariablesGroup.this.updateEnabledState();
                if (PathEntryVariablesGroup.this.selectionListener != null) {
                    PathEntryVariablesGroup.this.selectionListener.handleEvent(new Event());
                }
            }
        });
        data = new GridData(1808);
        data.heightHint = this.variableTable.getItemHeight() * 7;
        this.variableTable.setLayoutData((Object)data);
        this.variableTable.setFont(font);
        this.createButtonGroup(pageComponent);
        this.updateWidgetState(null);
        return pageComponent;
    }

    public void dispose() {
        if (this.imageUnkown != null) {
            this.imageUnkown.dispose();
            this.imageUnkown = null;
        }
    }

    protected void editSelectedVariable() {
        TableItem item = this.variableTable.getItem(this.variableTable.getSelectionIndex());
        String variableName = (String)item.getData();
        IPath variableValue = (IPath)this.tempPathVariables.get(variableName);
        PathEntryVariableDialog dialog = new PathEntryVariableDialog(this.shell, 2, this.variableType, this.tempPathVariables.keySet());
        dialog.setVariableName(variableName);
        dialog.setVariableValue(variableValue.toOSString());
        if (dialog.open() == 1) {
            return;
        }
        this.removedVariableNames.add(variableName);
        this.tempPathVariables.remove(variableName);
        String newVariableName = dialog.getVariableName();
        Path newVariableValue = new Path(dialog.getVariableValue());
        this.tempPathVariables.put(newVariableName, (IPath)newVariableValue);
        this.updateWidgetState(newVariableName);
    }

    public boolean getEnabled() {
        if (this.variableTable != null && !this.variableTable.isDisposed()) {
            return this.variableTable.getEnabled();
        }
        return true;
    }

    public PathEntryVariableElement[] getSelection() {
        if (this.variableTable == null) {
            return new PathEntryVariableElement[0];
        }
        TableItem[] items = this.variableTable.getSelection();
        PathEntryVariableElement[] selection = new PathEntryVariableElement[items.length];
        int i = 0;
        while (i < items.length) {
            String name = (String)items[i].getData();
            selection[i] = new PathEntryVariableElement();
            selection[i].name = name;
            selection[i].path = (IPath)this.tempPathVariables.get(name);
            ++i;
        }
        return selection;
    }

    private void createButtonGroup(Composite parent) {
        Font font = parent.getFont();
        Composite groupComponent = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.addButton = new Button(groupComponent, 8);
        this.addButton.setText(PreferencesMessages.PathEntryVariablesBlock_addVariableButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEntryVariablesGroup.this.addNewVariable();
            }
        });
        this.addButton.setFont(font);
        this.setButtonLayoutData(this.addButton);
        this.editButton = new Button(groupComponent, 8);
        this.editButton.setText(PreferencesMessages.PathEntryVariablesBlock_editVariableButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEntryVariablesGroup.this.editSelectedVariable();
            }
        });
        this.editButton.setFont(font);
        this.setButtonLayoutData(this.editButton);
        this.removeButton = new Button(groupComponent, 8);
        this.removeButton.setText(PreferencesMessages.PathEntryVariablesBlock_removeVariableButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEntryVariablesGroup.this.removeSelectedVariables();
            }
        });
        this.removeButton.setFont(font);
        this.setButtonLayoutData(this.removeButton);
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void initTemporaryState() {
        String[] varNames = this.pathEntryVariableManager.getVariableNames();
        this.tempPathVariables.clear();
        String[] stringArray = varNames;
        int n = varNames.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isFile;
            String varName = stringArray[n2];
            IPath value = this.pathEntryVariableManager.getValue(varName);
            if (value != null && ((isFile = value.toFile().isFile()) && (this.variableType & 1) != 0 || !isFile && (this.variableType & 2) != 0)) {
                this.tempPathVariables.put(varName, value);
            }
            ++n2;
        }
        this.removedVariableNames.clear();
    }

    protected void updateEnabledState() {
        int itemsSelectedCount = this.variableTable.getSelectionCount();
        this.editButton.setEnabled(itemsSelectedCount == 1);
        this.removeButton.setEnabled(itemsSelectedCount > 0);
    }

    private void updateVariableTable(String selectedVarName) {
        this.variableTable.removeAll();
        int selectedVarIndex = 0;
        for (String varName : this.tempPathVariables.keySet()) {
            TableItem item = new TableItem(this.variableTable, 0);
            IPath value = (IPath)this.tempPathVariables.get(varName);
            File file = value.toFile();
            item.setText(String.valueOf(varName) + " - " + value.toOSString());
            item.setData((Object)varName);
            item.setImage(file.exists() ? (file.isFile() ? this.FILE_IMG : this.FOLDER_IMG) : this.imageUnkown);
            if (!varName.equals(selectedVarName)) continue;
            selectedVarIndex = this.variableTable.getItemCount() - 1;
        }
        if (this.variableTable.getItemCount() > selectedVarIndex) {
            this.variableTable.setSelection(selectedVarIndex);
            if (this.selectionListener != null) {
                this.selectionListener.handleEvent(new Event());
            }
        } else if (this.variableTable.getItemCount() == 0 && this.selectionListener != null) {
            this.selectionListener.handleEvent(new Event());
        }
    }

    public boolean performOk() {
        try {
            for (String string : this.removedVariableNames) {
                if (this.tempPathVariables.containsKey(string)) continue;
                this.pathEntryVariableManager.setValue(string, null);
            }
            for (Map.Entry entry : this.tempPathVariables.entrySet()) {
                String variableName = (String)entry.getKey();
                IPath variableValue = (IPath)entry.getValue();
                this.pathEntryVariableManager.setValue(variableName, variableValue);
            }
            this.initTemporaryState();
            return true;
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)coreException.getStatus());
            return false;
        }
    }

    protected void removeSelectedVariables() {
        int[] selectedIndices;
        int[] nArray = selectedIndices = this.variableTable.getSelectionIndices();
        int n = selectedIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int selectedIndice = nArray[n2];
            TableItem selectedItem = this.variableTable.getItem(selectedIndice);
            String varName = (String)selectedItem.getData();
            this.removedVariableNames.add(varName);
            this.tempPathVariables.remove(varName);
            ++n2;
        }
        this.updateWidgetState(null);
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    public void setEnabled(boolean enabled) {
        if (this.variableTable != null && !this.variableTable.isDisposed()) {
            this.variableLabel.setEnabled(enabled);
            this.variableTable.setEnabled(enabled);
            this.addButton.setEnabled(enabled);
            if (enabled) {
                this.updateEnabledState();
            } else {
                this.editButton.setEnabled(enabled);
                this.removeButton.setEnabled(enabled);
            }
        }
    }

    private void updateWidgetState(String selectedVarName) {
        this.updateVariableTable(selectedVarName);
        this.updateEnabledState();
    }

    public static class PathEntryVariableElement {
        public String name;
        public IPath path;
    }
}

