/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.cdt.internal.ui.preferences.formatter.CustomCodeFormatterBlock;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterModifyDialog;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterProfileStore;
import org.eclipse.cdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.cdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.cdt.internal.ui.preferences.formatter.TranslationUnitPreview;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeFormatterConfigurationBlock
extends ProfileConfigurationBlock {
    private static final String FORMATTER_DIALOG_PREFERENCE_KEY = "formatter_page";
    private static final String DIALOGSTORE_LASTSAVELOADPATH = "org.eclipse.cdt.ui.codeformatter.savepath";
    private static final String PREVIEW = "/*\n* " + FormatterMessages.CodingStyleConfigurationBlock_preview_title + "\n*/\n" + "#include <math.h>\n\n" + "class Point {" + "public:" + "Point(double xc, double yc) : x(xc), y(yc) {}" + "double distance(const Point& other) const;" + "\n\n" + "double x;" + "double y;" + "};" + "\n\n" + "double Point::distance(const Point& other) const {" + "double dx = x - other.x;" + "double dy = y - other.y;" + "return sqrt(dx * dx + dy * dy);" + "}";
    protected TranslationUnitPreview fCodeStylePreview;
    protected CustomCodeFormatterBlock fCustomCodeFormatterBlock;

    public CodeFormatterConfigurationBlock(IProject project, PreferencesAccess access) {
        super(project, access, DIALOGSTORE_LASTSAVELOADPATH);
        this.fCustomCodeFormatterBlock = new CustomCodeFormatterBlock(project, access);
    }

    @Override
    protected IProfileVersioner createProfileVersioner() {
        return new ProfileVersioner();
    }

    @Override
    protected ProfileStore createProfileStore(IProfileVersioner versioner) {
        return new FormatterProfileStore(versioner);
    }

    @Override
    protected ProfileManager createProfileManager(List<ProfileManager.Profile> profiles, IScopeContext context, PreferencesAccess access, IProfileVersioner profileVersioner) {
        return new FormatterProfileManager(profiles, context, access, profileVersioner);
    }

    @Override
    protected void configurePreview(Composite composite, int numColumns, ProfileManager profileManager) {
        this.fCustomCodeFormatterBlock.createContents(composite);
        CodeFormatterConfigurationBlock.createLabel(composite, FormatterMessages.CodingStyleConfigurationBlock_preview_label_text, numColumns);
        TranslationUnitPreview result = new TranslationUnitPreview(profileManager.getSelected().getSettings(), composite);
        result.setFormatterId(this.fCustomCodeFormatterBlock.getFormatterId());
        result.setPreviewText(PREVIEW);
        this.fCodeStylePreview = result;
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fCodeStylePreview.getControl().setLayoutData((Object)gd);
        new PreviewController(profileManager);
    }

    @Override
    protected ModifyDialog createModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile) {
        return new FormatterModifyDialog(shell, profile, profileManager, profileStore, newProfile, FORMATTER_DIALOG_PREFERENCE_KEY, DIALOGSTORE_LASTSAVELOADPATH);
    }

    @Override
    public void performApply() {
        if (this.fCustomCodeFormatterBlock != null) {
            this.fCustomCodeFormatterBlock.performOk();
        }
        super.performApply();
    }

    @Override
    public void performDefaults() {
        if (this.fCustomCodeFormatterBlock != null) {
            this.fCustomCodeFormatterBlock.performDefaults();
        }
        super.performDefaults();
    }

    @Override
    public boolean performOk() {
        if (this.fCustomCodeFormatterBlock != null) {
            this.fCustomCodeFormatterBlock.performOk();
        }
        return super.performOk();
    }

    private class PreviewController
    implements Observer {
        public PreviewController(ProfileManager profileManager) {
            profileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fCustomCodeFormatterBlock.addObserver(this);
            CodeFormatterConfigurationBlock.this.fCodeStylePreview.setWorkingValues(profileManager.getSelected().getSettings());
            CodeFormatterConfigurationBlock.this.fCodeStylePreview.update();
        }

        public void update(Observable o, Object arg) {
            if (o == CodeFormatterConfigurationBlock.this.fCustomCodeFormatterBlock) {
                CodeFormatterConfigurationBlock.this.fCodeStylePreview.setFormatterId((String)arg);
                CodeFormatterConfigurationBlock.this.fCodeStylePreview.update();
                return;
            }
            int value = (Integer)arg;
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    CodeFormatterConfigurationBlock.this.fCodeStylePreview.setWorkingValues(((ProfileManager)o).getSelected().getSettings());
                    CodeFormatterConfigurationBlock.this.fCodeStylePreview.update();
                }
            }
        }
    }
}

