/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.cdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileVersioner
implements IProfileVersioner {
    public static final String CODE_FORMATTER_PROFILE_KIND = "CodeFormatterProfile";
    public static final int VERSION_1 = 1;
    public static final int CURRENT_VERSION = 1;

    @Override
    public int getFirstVersion() {
        return 1;
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public String getProfileKind() {
        return CODE_FORMATTER_PROFILE_KIND;
    }

    @Override
    public void update(ProfileManager.CustomProfile profile) {
        Map<String, String> oldSettings = profile.getSettings();
        Map<String, String> newSettings = ProfileVersioner.updateAndComplete(oldSettings, profile.getVersion());
        profile.setVersion(1);
        profile.setSettings(newSettings);
    }

    public static int getVersionStatus(ProfileManager.CustomProfile profile) {
        int version = profile.getVersion();
        if (version < 1) {
            return -1;
        }
        if (version > 1) {
            return 1;
        }
        return 0;
    }

    public static void updateAndComplete(ProfileManager.CustomProfile profile) {
        Map<String, String> oldSettings = profile.getSettings();
        Map<String, String> newSettings = ProfileVersioner.updateAndComplete(oldSettings, profile.getVersion());
        profile.setVersion(1);
        profile.setSettings(newSettings);
    }

    public static Map<String, String> updateAndComplete(Map<String, String> oldSettings, int version) {
        Map<String, String> newSettings = FormatterProfileManager.getDefaultSettings();
        for (String element : oldSettings.keySet()) {
            String value;
            String key = element;
            if (!newSettings.containsKey(key) || (value = oldSettings.get(key)) == null) continue;
            newSettings.put(key, value);
        }
        return newSettings;
    }
}

