/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class ChangeTreeSet {
    private final TreeSet<CTextFileChange> changes = new TreeSet<CTextFileChange>(new ChangePositionComparator());

    public void add(CTextFileChange change) {
        this.changes.add(change);
    }

    public CompositeChange getCompositeChange(String name) {
        CompositeChange allChanges = new CompositeChange(name);
        for (Change change : this.changes) {
            allChanges.add(change);
        }
        return allChanges;
    }

    public String toString() {
        return this.changes.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangePositionComparator
    implements Comparator<CTextFileChange> {
        private ChangePositionComparator() {
        }

        @Override
        public int compare(CTextFileChange o1, CTextFileChange o2) {
            if (o1.getFile().equals((Object)o2.getFile())) {
                return o2.getEdit().getOffset() - o1.getEdit().getOffset();
            }
            return o2.getFile().hashCode() - o1.getFile().hashCode();
        }
    }
}

