/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;

public class Visibility {
    public static final Visibility PUBLIC = new Visibility(){

        public String stringValue() {
            return "public";
        }
    };
    public static final Visibility PROTECTED = new Visibility(){

        public String stringValue() {
            return "protected";
        }
    };
    public static final Visibility PRIVATE = new Visibility(){

        public String stringValue() {
            return "private";
        }
    };
    public static final Visibility UNKNOWN = new Visibility(){};

    private Visibility() {
    }

    public static Visibility getVisibility(IASTName name) {
        try {
            ICPPMember member = (ICPPMember)name.resolveBinding();
            switch (member.getVisibility()) {
                case 1: {
                    return PUBLIC;
                }
                case 2: {
                    return PROTECTED;
                }
                case 3: {
                    return PRIVATE;
                }
            }
            return UNKNOWN;
        }
        catch (DOMException dOMException) {
            return UNKNOWN;
        }
        catch (RuntimeException runtimeException) {
            return UNKNOWN;
        }
    }

    public String stringValue() {
        return "";
    }

    public String toString() {
        return this.stringValue();
    }

    /* synthetic */ Visibility(Visibility visibility) {
        this();
    }
}

