/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractconstant;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTInitializerExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.ui.refactoring.AddDeclarationNodeToClassChange;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.ExtractConstantInfo;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.TranslationUnitHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractConstantRefactoring
extends CRefactoring {
    private IASTLiteralExpression target = null;
    private final ArrayList<IASTExpression> literalsToReplace = new ArrayList();
    private final ExtractConstantInfo info;

    public ExtractConstantRefactoring(IFile file, ISelection selection, ExtractConstantInfo info) {
        super(file, selection, null);
        this.info = info;
        this.name = Messages.ExtractConstantRefactoring_ExtractConst;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean oneMarked;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)9);
        RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        if (status.hasError()) {
            return status;
        }
        Collection<IASTLiteralExpression> literalExpressionCollection = this.findAllLiterals();
        if (literalExpressionCollection.isEmpty()) {
            this.initStatus.addFatalError(Messages.ExtractConstantRefactoring_LiteralMustBeSelected);
            return this.initStatus;
        }
        sm.worked(1);
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        boolean bl = oneMarked = this.region != null && this.isOneMarked(literalExpressionCollection, this.region);
        if (!oneMarked) {
            if (this.target == null) {
                this.initStatus.addFatalError(Messages.ExtractConstantRefactoring_NoLiteralSelected);
            } else {
                this.initStatus.addFatalError(Messages.ExtractConstantRefactoring_TooManyLiteralSelected);
            }
            return this.initStatus;
        }
        sm.worked(1);
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        this.findAllNodesForReplacement(literalExpressionCollection);
        this.info.addNamesToUsedNames(this.findAllDeclaredNames());
        this.info.setName(this.getDefaultName(this.target));
        this.info.setMContext(NodeHelper.findMethodContext((IASTNode)this.target, this.getIndex()));
        sm.done();
        return this.initStatus;
    }

    private String getDefaultName(IASTLiteralExpression literal) {
        String nameString = literal.toString();
        switch (literal.getKind()) {
            case 2: 
            case 3: {
                int len;
                int beginIndex = 1;
                if (nameString.startsWith("L")) {
                    beginIndex = 2;
                }
                if (beginIndex >= (len = nameString.length()) || len <= 0) break;
                nameString = nameString.substring(beginIndex, len - 1);
                break;
            }
        }
        nameString = nameString.replaceAll("[\\W]", "_");
        return String.valueOf('_') + nameString;
    }

    private ArrayList<String> findAllDeclaredNames() {
        ArrayList<String> names = new ArrayList<String>();
        IASTFunctionDefinition funcDef = NodeHelper.findFunctionDefinitionInAncestors((IASTNode)this.target);
        ICPPASTCompositeTypeSpecifier comTypeSpec = this.getCompositeTypeSpecifier(funcDef);
        if (comTypeSpec != null) {
            IASTDeclaration[] iASTDeclarationArray = comTypeSpec.getMembers();
            int n = iASTDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration dec = iASTDeclarationArray[n2];
                if (dec instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpDec = (IASTSimpleDeclaration)dec;
                    IASTDeclarator[] iASTDeclaratorArray = simpDec.getDeclarators();
                    int n3 = iASTDeclaratorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTDeclarator decor = iASTDeclaratorArray[n4];
                        names.add(decor.getName().getRawSignature());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return names;
    }

    private ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier(IASTFunctionDefinition funcDef) {
        CPPMethod methode;
        IASTNode[] declarations;
        IASTNode decl;
        IASTNode spec;
        IBinding binding;
        if (funcDef != null && (binding = funcDef.getDeclarator().getName().resolveBinding()) instanceof CPPMethod && (spec = (decl = (declarations = (methode = (CPPMethod)binding).getDeclarations()) != null ? declarations[0] : methode.getDefinition()).getParent().getParent()) instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier compTypeSpec = (ICPPASTCompositeTypeSpecifier)spec;
            return compTypeSpec;
        }
        return null;
    }

    private void findAllNodesForReplacement(Collection<IASTLiteralExpression> literalExpressionCollection) {
        if (this.target.getParent() instanceof IASTUnaryExpression) {
            IASTUnaryExpression unary = (IASTUnaryExpression)this.target.getParent();
            for (IASTLiteralExpression expression : literalExpressionCollection) {
                if (this.target.getKind() != expression.getKind() || !this.target.toString().equals(expression.toString()) || !(expression.getParent() instanceof IASTUnaryExpression) || unary.getOperator() != ((IASTUnaryExpression)expression.getParent()).getOperator()) continue;
                this.literalsToReplace.add((IASTExpression)((IASTUnaryExpression)expression.getParent()));
            }
        } else {
            for (IASTLiteralExpression expression : literalExpressionCollection) {
                if (this.target.getKind() != expression.getKind() || !this.target.toString().equals(expression.toString())) continue;
                this.literalsToReplace.add((IASTExpression)expression);
            }
        }
    }

    private boolean isOneMarked(Collection<IASTLiteralExpression> literalExpressionCollection, Region textSelection) {
        boolean oneMarked = false;
        for (IASTLiteralExpression expression : literalExpressionCollection) {
            boolean isInSameFileSelection = SelectionHelper.isInSameFileSelection(textSelection, (IASTNode)expression, this.file);
            if (!isInSameFileSelection) continue;
            if (this.target == null) {
                this.target = expression;
                oneMarked = true;
                continue;
            }
            oneMarked = false;
        }
        return oneMarked;
    }

    private Collection<IASTLiteralExpression> findAllLiterals() {
        final ArrayList<IASTLiteralExpression> result = new ArrayList<IASTLiteralExpression>();
        this.unit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTExpression expression) {
                if (expression instanceof IASTLiteralExpression && (expression.getNodeLocations().length != 1 || !(expression.getNodeLocations()[0] instanceof IASTMacroExpansionLocation))) {
                    IASTLiteralExpression literal = (IASTLiteralExpression)expression;
                    result.add(literal);
                }
                return super.visit(expression);
            }
        });
        return result;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        MethodContext context = this.info.getMContext();
        ArrayList<IASTExpression> locLiteralsToReplace = new ArrayList<IASTExpression>();
        if (context.getType() == MethodContext.ContextType.METHOD) {
            for (IASTExpression expression : this.literalsToReplace) {
                MethodContext exprContext = NodeHelper.findMethodContext((IASTNode)expression, this.getIndex());
                if (exprContext.getType() != MethodContext.ContextType.METHOD) continue;
                if (context.getMethodQName() != null) {
                    if (!MethodContext.isSameClass(exprContext.getMethodQName(), context.getMethodQName())) continue;
                    locLiteralsToReplace.add(expression);
                    continue;
                }
                if (!MethodContext.isSameClass(exprContext.getMethodDeclarationName(), context.getMethodDeclarationName())) continue;
                locLiteralsToReplace.add(expression);
            }
        } else {
            for (IASTExpression expression : this.literalsToReplace) {
                Path path = new Path(expression.getContainingFilename());
                IFile expressionFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                if (expressionFile == null || !expressionFile.equals((Object)this.file)) continue;
                locLiteralsToReplace.add(expression);
            }
        }
        String constName = this.info.getName();
        this.createLiteralToConstantChanges(constName, locLiteralsToReplace, collector);
        if (context.getType() == MethodContext.ContextType.METHOD) {
            ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)context.getMethodDeclaration().getParent();
            AddDeclarationNodeToClassChange.createChange(classDefinition, this.info.getVisibility(), (IASTNode)this.getConstNodesClass(constName), true, collector);
        } else {
            IASTDeclaration nodes = this.getConstNodesGlobal(constName);
            ASTRewrite rewriter = collector.rewriterForTranslationUnit(this.unit);
            rewriter.insertBefore((IASTNode)this.unit, TranslationUnitHelper.getFirstNode(this.unit), (IASTNode)nodes, new TextEditGroup(Messages.ExtractConstantRefactoring_CreateConstant));
        }
    }

    private void createLiteralToConstantChanges(String constName, Iterable<? extends IASTExpression> literals, ModificationCollector collector) {
        for (IASTExpression iASTExpression : literals) {
            ASTRewrite rewrite = collector.rewriterForTranslationUnit(iASTExpression.getTranslationUnit());
            CPPASTIdExpression idExpression = new CPPASTIdExpression((IASTName)new CPPASTName(constName.toCharArray()));
            rewrite.replace((IASTNode)iASTExpression, (IASTNode)idExpression, new TextEditGroup(Messages.ExtractConstantRefactoring_ReplaceLiteral));
        }
    }

    private IASTSimpleDeclaration getConstNodes(String newName) {
        CPPASTSimpleDeclSpecifier declSpec = new CPPASTSimpleDeclSpecifier();
        declSpec.setConst(true);
        switch (this.target.getKind()) {
            case 2: {
                declSpec.setType(2);
                break;
            }
            case 1: {
                declSpec.setType(4);
                break;
            }
            case 0: {
                declSpec.setType(3);
                break;
            }
            case 3: {
                declSpec.setType(7);
                break;
            }
            case 5: 
            case 6: {
                declSpec.setType(6);
                break;
            }
        }
        CPPASTSimpleDeclaration simple = new CPPASTSimpleDeclaration();
        simple.setDeclSpecifier((IASTDeclSpecifier)declSpec);
        CPPASTDeclarator decl = new CPPASTDeclarator();
        CPPASTName name = new CPPASTName(newName.toCharArray());
        decl.setName((IASTName)name);
        CPPASTInitializerExpression init = new CPPASTInitializerExpression();
        if (this.target.getParent() instanceof IASTUnaryExpression) {
            IASTUnaryExpression unary = (IASTUnaryExpression)this.target.getParent();
            init.setExpression((IASTExpression)unary);
        } else {
            CPPASTLiteralExpression expression = new CPPASTLiteralExpression(this.target.getKind(), this.target.getValue());
            init.setExpression((IASTExpression)expression);
        }
        decl.setInitializer((IASTInitializer)init);
        simple.addDeclarator((IASTDeclarator)decl);
        return simple;
    }

    private IASTDeclaration getConstNodesGlobal(String newName) {
        IASTSimpleDeclaration simple = this.getConstNodes(newName);
        if (this.unit.getParserLanguage().isCPP()) {
            CPPASTNamespaceDefinition namespace = new CPPASTNamespaceDefinition();
            namespace.setName((IASTName)new CPPASTName());
            namespace.addDeclaration((IASTDeclaration)simple);
            return namespace;
        }
        simple.getDeclSpecifier().setStorageClass(3);
        return simple;
    }

    private IASTDeclaration getConstNodesClass(String newName) {
        IASTSimpleDeclaration simple = this.getConstNodes(newName);
        simple.getDeclSpecifier().setStorageClass(3);
        return simple;
    }
}

