/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypenameExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTPointer;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.EqualityChecker;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.TrailName;
import org.eclipse.cdt.internal.ui.refactoring.utils.ASTHelper;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrailNodeEqualityChecker
implements EqualityChecker<IASTNode> {
    private final Map<String, Integer> names;
    private final Container<Integer> namesCounter;

    public TrailNodeEqualityChecker(Map<String, Integer> names, Container<Integer> namesCounter) {
        this.names = names;
        this.namesCounter = namesCounter;
    }

    @Override
    public boolean isEquals(IASTNode trailNode, IASTNode node) {
        if (trailNode instanceof TrailName && node instanceof IASTName || Arrays.equals(this.getInterfaces(node), this.getInterfaces(trailNode))) {
            if (node instanceof IASTExpression) {
                return this.isExpressionEquals(trailNode, node);
            }
            if (node instanceof IASTStatement) {
                return this.isStatementEquals(trailNode, node);
            }
            if (node instanceof IASTPointerOperator) {
                return this.isPointerOperatorEquals(trailNode, node);
            }
            if (node instanceof IASTDeclaration) {
                return this.isDeclarationEquals(trailNode, node);
            }
            if (node instanceof IASTDeclarator) {
                return this.isDeclaratorEquals(trailNode, node);
            }
            if (node instanceof IASTInitializer) {
                return true;
            }
            if (node instanceof IASTDeclSpecifier) {
                return this.isDeclSpecifierEquals(trailNode, node);
            }
            if (node instanceof IASTName) {
                return this.isNameEquals(trailNode, node);
            }
            Assert.isLegal((boolean)false, (String)"Unexpected Node, this code shoud nod reached");
            return true;
        }
        return false;
    }

    private boolean isNameEquals(IASTNode trailNode, IASTNode node) {
        if (trailNode instanceof ICPPASTConversionName) {
            return true;
        }
        if (trailNode instanceof ICPPASTOperatorName) {
            ICPPASTOperatorName trailName = (ICPPASTOperatorName)trailNode;
            ICPPASTOperatorName name = (ICPPASTOperatorName)node;
            return trailName.equals(name);
        }
        if (trailNode instanceof TrailName && node instanceof IASTName) {
            TrailName trailName = (TrailName)trailNode;
            IASTName name = (IASTName)node;
            return this.isNameEquals(trailName, name);
        }
        return true;
    }

    private boolean isDeclSpecifierEquals(IASTNode trailNode, IASTNode node) {
        if (trailNode instanceof IGPPASTSimpleDeclSpecifier) {
            IGPPASTSimpleDeclSpecifier trailSimpleDecl = (IGPPASTSimpleDeclSpecifier)trailNode;
            IGPPASTSimpleDeclSpecifier simpleDecl = (IGPPASTSimpleDeclSpecifier)node;
            return this.isSimpleDeclSpecifierEquals((IASTSimpleDeclSpecifier)trailSimpleDecl, (IASTSimpleDeclSpecifier)simpleDecl) && trailSimpleDecl.isComplex() == simpleDecl.isComplex() && trailSimpleDecl.isImaginary() == simpleDecl.isImaginary() && trailSimpleDecl.isLongLong() == simpleDecl.isLongLong() && trailSimpleDecl.isComplex() == simpleDecl.isComplex() && trailSimpleDecl.isExplicit() == simpleDecl.isExplicit() && trailSimpleDecl.isFriend() == simpleDecl.isFriend();
        }
        if (trailNode instanceof IGPPASTDeclSpecifier) {
            IGPPASTDeclSpecifier trailDecl = (IGPPASTDeclSpecifier)trailNode;
            IGPPASTDeclSpecifier decl = (IGPPASTDeclSpecifier)node;
            return this.isDeclSpecifierEquals((IASTDeclSpecifier)trailDecl, (IASTDeclSpecifier)decl) && trailDecl.isRestrict() == decl.isRestrict();
        }
        if (trailNode instanceof ICASTSimpleDeclSpecifier) {
            ICASTSimpleDeclSpecifier trailDecl = (ICASTSimpleDeclSpecifier)trailNode;
            ICASTSimpleDeclSpecifier decl = (ICASTSimpleDeclSpecifier)node;
            return this.isSimpleDeclSpecifierEquals((IASTSimpleDeclSpecifier)trailDecl, (IASTSimpleDeclSpecifier)decl) && trailDecl.isRestrict() == decl.isRestrict() && trailDecl.isComplex() == decl.isComplex() && trailDecl.isImaginary() == decl.isImaginary() && trailDecl.isLongLong() == decl.isLongLong();
        }
        if (trailNode instanceof IASTSimpleDeclSpecifier) {
            IASTSimpleDeclSpecifier trailDecl = (IASTSimpleDeclSpecifier)trailNode;
            IASTSimpleDeclSpecifier decl = (IASTSimpleDeclSpecifier)node;
            return this.isSimpleDeclSpecifierEquals(trailDecl, decl);
        }
        if (trailNode instanceof ICPPASTNamedTypeSpecifier) {
            ICPPASTNamedTypeSpecifier trailDecl = (ICPPASTNamedTypeSpecifier)trailNode;
            ICPPASTNamedTypeSpecifier decl = (ICPPASTNamedTypeSpecifier)node;
            boolean isSame = this.isDeclSpecifierEquals((IASTDeclSpecifier)trailDecl, (IASTDeclSpecifier)decl) && this.isSameNamedTypeSpecifierName((IASTNamedTypeSpecifier)trailDecl, (IASTNamedTypeSpecifier)decl) && trailDecl.isTypename() == decl.isTypename() && trailDecl.isExplicit() == decl.isExplicit() && trailDecl.isFriend() == decl.isFriend() && trailDecl.isVirtual() == decl.isVirtual();
            return isSame;
        }
        if (trailNode instanceof IASTNamedTypeSpecifier) {
            IASTNamedTypeSpecifier trailDecl = (IASTNamedTypeSpecifier)trailNode;
            IASTNamedTypeSpecifier decl = (IASTNamedTypeSpecifier)node;
            return this.isDeclSpecifierEquals((IASTDeclSpecifier)trailDecl, (IASTDeclSpecifier)decl) && this.isSameNamedTypeSpecifierName(trailDecl, decl);
        }
        if (trailNode instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier trailDecl = (IASTElaboratedTypeSpecifier)trailNode;
            IASTElaboratedTypeSpecifier decl = (IASTElaboratedTypeSpecifier)node;
            return this.isDeclSpecifierEquals((IASTDeclSpecifier)trailDecl, (IASTDeclSpecifier)decl) && trailDecl.getKind() == decl.getKind();
        }
        if (trailNode instanceof IASTCompositeTypeSpecifier) {
            IASTCompositeTypeSpecifier trailDecl = (IASTCompositeTypeSpecifier)trailNode;
            IASTCompositeTypeSpecifier decl = (IASTCompositeTypeSpecifier)node;
            return this.isDeclSpecifierEquals((IASTDeclSpecifier)trailDecl, (IASTDeclSpecifier)decl) && trailDecl.getKey() == decl.getKey();
        }
        if (trailNode instanceof ICPPASTDeclSpecifier) {
            ICPPASTDeclSpecifier trailDecl = (ICPPASTDeclSpecifier)trailNode;
            ICPPASTDeclSpecifier decl = (ICPPASTDeclSpecifier)node;
            return this.isDeclSpecifierEquals((IASTDeclSpecifier)trailDecl, (IASTDeclSpecifier)decl) && trailDecl.isExplicit() == decl.isExplicit() && trailDecl.isFriend() == decl.isFriend() && trailDecl.isVirtual() == decl.isVirtual();
        }
        if (trailNode instanceof ICASTDeclSpecifier) {
            ICASTDeclSpecifier trailDecl = (ICASTDeclSpecifier)trailNode;
            ICASTDeclSpecifier decl = (ICASTDeclSpecifier)node;
            return this.isDeclSpecifierEquals((IASTDeclSpecifier)trailDecl, (IASTDeclSpecifier)decl) && trailDecl.isRestrict() == decl.isRestrict();
        }
        if (trailNode instanceof IASTDeclSpecifier) {
            IASTDeclSpecifier trailDecl = (IASTDeclSpecifier)trailNode;
            IASTDeclSpecifier decl = (IASTDeclSpecifier)node;
            return this.isDeclSpecifierEquals(trailDecl, decl);
        }
        return true;
    }

    private boolean isDeclaratorEquals(IASTNode trailNode, IASTNode node) {
        if (trailNode instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator trailFunc = (IASTStandardFunctionDeclarator)trailNode;
            IASTStandardFunctionDeclarator func = (IASTStandardFunctionDeclarator)node;
            return trailFunc.takesVarArgs() == func.takesVarArgs();
        }
        if (trailNode instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator trailFunc = (ICPPASTFunctionDeclarator)trailNode;
            ICPPASTFunctionDeclarator func = (ICPPASTFunctionDeclarator)node;
            return trailFunc.isConst() == func.isConst() && trailFunc.isPureVirtual() == func.isPureVirtual() && trailFunc.isVolatile() == func.isVolatile();
        }
        return true;
    }

    private boolean isDeclarationEquals(IASTNode trailNode, IASTNode node) {
        if (trailNode instanceof IASTASMDeclaration) {
            IASTASMDeclaration trailASMDecl = (IASTASMDeclaration)trailNode;
            IASTASMDeclaration asmDecl = (IASTASMDeclaration)node;
            return trailASMDecl.getAssembly().equals(asmDecl.getAssembly());
        }
        if (trailNode instanceof IGPPASTExplicitTemplateInstantiation) {
            IGPPASTExplicitTemplateInstantiation trailTempl = (IGPPASTExplicitTemplateInstantiation)trailNode;
            IGPPASTExplicitTemplateInstantiation templ = (IGPPASTExplicitTemplateInstantiation)node;
            return trailTempl.getModifier() == templ.getModifier();
        }
        if (trailNode instanceof ICPPASTLinkageSpecification) {
            ICPPASTLinkageSpecification trailLink = (ICPPASTLinkageSpecification)trailNode;
            ICPPASTLinkageSpecification link = (ICPPASTLinkageSpecification)node;
            return trailLink.getLiteral().equals(link.getLiteral());
        }
        if (trailNode instanceof ICPPASTTemplateDeclaration) {
            ICPPASTTemplateDeclaration trailTempl = (ICPPASTTemplateDeclaration)trailNode;
            ICPPASTTemplateDeclaration templ = (ICPPASTTemplateDeclaration)node;
            return trailTempl.isExported() == templ.isExported();
        }
        if (trailNode instanceof ICPPASTUsingDeclaration) {
            ICPPASTUsingDeclaration trailUsing = (ICPPASTUsingDeclaration)trailNode;
            ICPPASTUsingDeclaration using = (ICPPASTUsingDeclaration)node;
            return trailUsing.isTypename() == using.isTypename();
        }
        if (trailNode instanceof ICPPASTVisibilityLabel) {
            ICPPASTVisibilityLabel trailVisibility = (ICPPASTVisibilityLabel)trailNode;
            ICPPASTVisibilityLabel visibility = (ICPPASTVisibilityLabel)node;
            return trailVisibility.getVisibility() == visibility.getVisibility();
        }
        return true;
    }

    private boolean isPointerOperatorEquals(IASTNode trailNode, IASTNode node) {
        if (trailNode instanceof IGPPASTPointer) {
            IGPPASTPointer trailGPointer = (IGPPASTPointer)trailNode;
            IGPPASTPointer gPointer = (IGPPASTPointer)node;
            return trailGPointer.isConst() == gPointer.isConst() && trailGPointer.isRestrict() == gPointer.isRestrict() && trailGPointer.isVolatile() == gPointer.isVolatile();
        }
        if (trailNode instanceof ICASTPointer) {
            ICASTPointer trailCPointer = (ICASTPointer)trailNode;
            ICASTPointer cPointer = (ICASTPointer)node;
            return trailCPointer.isConst() == cPointer.isConst() && trailCPointer.isRestrict() == cPointer.isRestrict() && trailCPointer.isVolatile() == cPointer.isVolatile();
        }
        if (trailNode instanceof IASTPointer) {
            IASTPointer trailCPointer = (IASTPointer)trailNode;
            IASTPointer cPointer = (IASTPointer)node;
            return trailCPointer.isConst() == cPointer.isConst() && trailCPointer.isVolatile() == cPointer.isVolatile();
        }
        return true;
    }

    private boolean isStatementEquals(IASTNode trailNode, IASTNode node) {
        if (trailNode instanceof ICPPASTCatchHandler) {
            ICPPASTCatchHandler trailCatch = (ICPPASTCatchHandler)trailNode;
            ICPPASTCatchHandler nodeCatch = (ICPPASTCatchHandler)node;
            return trailCatch.isCatchAll() == nodeCatch.isCatchAll();
        }
        return true;
    }

    private boolean isExpressionEquals(IASTNode trailNode, IASTNode node) {
        if (trailNode instanceof IASTBinaryExpression) {
            IASTBinaryExpression trailExpr = (IASTBinaryExpression)trailNode;
            IASTBinaryExpression expr = (IASTBinaryExpression)node;
            return trailExpr.getOperator() == expr.getOperator();
        }
        if (trailNode instanceof ICPPASTFieldReference) {
            ICPPASTFieldReference trailFieldRef = (ICPPASTFieldReference)trailNode;
            ICPPASTFieldReference fieldRef = (ICPPASTFieldReference)node;
            return trailFieldRef.isPointerDereference() == fieldRef.isPointerDereference() && trailFieldRef.isTemplate() == fieldRef.isTemplate();
        }
        if (trailNode instanceof IASTFieldReference) {
            IASTFieldReference trailFieldRef = (IASTFieldReference)trailNode;
            IASTFieldReference fieldRef = (IASTFieldReference)node;
            return trailFieldRef.isPointerDereference() == fieldRef.isPointerDereference();
        }
        if (trailNode instanceof IASTLiteralExpression) {
            IASTLiteralExpression trailLiteral = (IASTLiteralExpression)trailNode;
            IASTLiteralExpression literal = (IASTLiteralExpression)node;
            return trailLiteral.getKind() == literal.getKind() && trailLiteral.toString().equals(literal.toString());
        }
        if (trailNode instanceof IASTUnaryExpression) {
            IASTUnaryExpression trailExpr = (IASTUnaryExpression)trailNode;
            IASTUnaryExpression expr = (IASTUnaryExpression)node;
            return trailExpr.getOperator() == expr.getOperator();
        }
        if (trailNode instanceof IASTTypeIdExpression) {
            IASTTypeIdExpression trailIdExpr = (IASTTypeIdExpression)trailNode;
            IASTTypeIdExpression idExpr = (IASTTypeIdExpression)node;
            return trailIdExpr.getTypeId() == idExpr.getTypeId();
        }
        if (trailNode instanceof ICPPASTDeleteExpression) {
            ICPPASTDeleteExpression trailDelete = (ICPPASTDeleteExpression)trailNode;
            ICPPASTDeleteExpression delete = (ICPPASTDeleteExpression)node;
            return trailDelete.isGlobal() == delete.isGlobal() && trailDelete.isVectored() == delete.isVectored();
        }
        if (trailNode instanceof ICPPASTNewExpression) {
            ICPPASTNewExpression trailNew = (ICPPASTNewExpression)trailNode;
            ICPPASTNewExpression nodeNew = (ICPPASTNewExpression)node;
            return trailNew.isGlobal() == nodeNew.isGlobal() && trailNew.isNewTypeId() == nodeNew.isNewTypeId();
        }
        if (trailNode instanceof ICPPASTSimpleTypeConstructorExpression) {
            ICPPASTSimpleTypeConstructorExpression trailConsExpr = (ICPPASTSimpleTypeConstructorExpression)trailNode;
            ICPPASTSimpleTypeConstructorExpression consExpr = (ICPPASTSimpleTypeConstructorExpression)node;
            return trailConsExpr.getSimpleType() == consExpr.getSimpleType();
        }
        if (trailNode instanceof ICPPASTTypenameExpression) {
            ICPPASTTypenameExpression trailTypenameExpr = (ICPPASTTypenameExpression)trailNode;
            ICPPASTTypenameExpression typenameExpr = (ICPPASTTypenameExpression)node;
            return trailTypenameExpr.isTemplate() == typenameExpr.isTemplate();
        }
        return true;
    }

    private boolean isSameNamedTypeSpecifierName(IASTNamedTypeSpecifier trailDecl, IASTNamedTypeSpecifier decl) {
        return trailDecl.getName().getRawSignature().equals(decl.getName().getRawSignature());
    }

    private Class<?>[] getInterfaces(IASTNode node) {
        Class<?>[] interfaces = node.getClass().getInterfaces();
        List<Class<?>> interfaceList = Arrays.asList(interfaces);
        Class[] returnArray = new Class[interfaceList.size()];
        return interfaceList.toArray(returnArray);
    }

    private boolean isDeclSpecifierEquals(IASTDeclSpecifier trailDeclSpeci, IASTDeclSpecifier declSpeci) {
        return trailDeclSpeci.isConst() == declSpeci.isConst() && trailDeclSpeci.isInline() == declSpeci.isInline() && trailDeclSpeci.isVolatile() == declSpeci.isVolatile() && trailDeclSpeci.getStorageClass() == declSpeci.getStorageClass();
    }

    private boolean isSimpleDeclSpecifierEquals(IASTSimpleDeclSpecifier trailDeclSpeci, IASTSimpleDeclSpecifier declSpeci) {
        return this.isDeclSpecifierEquals((IASTDeclSpecifier)trailDeclSpeci, (IASTDeclSpecifier)declSpeci) && trailDeclSpeci.isLong() == declSpeci.isLong() && trailDeclSpeci.isShort() == declSpeci.isShort() && trailDeclSpeci.isSigned() == declSpeci.isSigned() && trailDeclSpeci.isUnsigned() == declSpeci.isUnsigned() && trailDeclSpeci.getType() == declSpeci.getType();
    }

    private boolean isNameEquals(TrailName trailName, IASTName name) {
        IASTNode tmpNode;
        int actCount = this.namesCounter.getObject();
        if (this.names.containsKey(name.getRawSignature())) {
            Integer nameId = this.names.get(name.getRawSignature());
            actCount = nameId;
        } else {
            this.namesCounter.setObject(++actCount);
            this.names.put(name.getRawSignature(), this.namesCounter.getObject());
        }
        if (actCount != trailName.getNameNumber()) {
            return false;
        }
        IBinding bind = name.resolveBinding();
        IASTName[] declNames = name.getTranslationUnit().getDeclarationsInAST(bind);
        if (declNames.length > 0 && (tmpNode = ASTHelper.getDeclarationForNode((IASTNode)declNames[0])) != null) {
            if (trailName.isGloballyQualified()) {
                if (tmpNode.equals(trailName.getDeclaration())) {
                    return true;
                }
            } else {
                IASTDeclSpecifier decl = ASTHelper.getDeclarationSpecifier(tmpNode);
                IASTDeclSpecifier trailDecl = trailName.getDeclSpecifier();
                IASTDeclarator declarator = ASTHelper.getDeclaratorForNode((IASTNode)declNames[0]);
                IASTDeclarator trailDeclarator = ASTHelper.getDeclaratorForNode(trailName.getDeclaration());
                IASTPointerOperator[] pointerOperators1 = declarator.getPointerOperators();
                IASTPointerOperator[] pointerOperators2 = trailDeclarator.getPointerOperators();
                if (trailDecl != null && decl != null && decl.getStorageClass() == trailDecl.getStorageClass() && ASTHelper.samePointers(pointerOperators1, pointerOperators2, this)) {
                    if (decl instanceof IASTSimpleDeclSpecifier && trailDecl instanceof IASTSimpleDeclSpecifier) {
                        IASTSimpleDeclSpecifier simpleDecl = (IASTSimpleDeclSpecifier)decl;
                        IASTSimpleDeclSpecifier simpleTrailDecl = (IASTSimpleDeclSpecifier)trailDecl;
                        if (simpleDecl.getType() == simpleTrailDecl.getType()) {
                            return true;
                        }
                    } else if (decl instanceof IASTNamedTypeSpecifier && trailDecl instanceof IASTNamedTypeSpecifier) {
                        IASTNamedTypeSpecifier namedDecl = (IASTNamedTypeSpecifier)decl;
                        IASTNamedTypeSpecifier trailNamedDecl = (IASTNamedTypeSpecifier)trailDecl;
                        if (namedDecl.getName().getRawSignature().equals(trailNamedDecl.getName().getRawSignature())) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

