/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

public class DelayedJobRunner {
    private Runnable job;
    private long lastUpdateEventTime;
    private long delayTimeInMillis;
    private boolean shouldStop;
    private boolean shouldUpdate;
    private static final long sleepTimeInMillis = 50L;

    public DelayedJobRunner(Runnable job, long delayTimeInMillis) {
        this.job = job;
        this.delayTimeInMillis = delayTimeInMillis;
        this.shouldUpdate = true;
    }

    public void start() {
        this.shouldStop = false;
        new Thread(new Runnable(){

            public void run() {
                DelayedJobRunner.this.startUpdateLoop();
            }
        }).start();
    }

    public void runJob() {
        this.shouldUpdate = true;
        this.lastUpdateEventTime = System.currentTimeMillis();
    }

    private void startUpdateLoop() {
        try {
            while (!this.shouldStop) {
                if (this.shouldUpdate && this.isDelayTimeOver()) {
                    this.lastUpdateEventTime = System.currentTimeMillis();
                    this.shouldUpdate = false;
                    this.job.run();
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception exception) {}
    }

    private boolean isDelayTimeOver() {
        long currentTime = System.currentTimeMillis();
        return this.lastUpdateEventTime + this.delayTimeInMillis < currentTime;
    }

    public void stop() {
        this.shouldStop = true;
    }
}

