/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.internal.ui.text.CBraceRule;
import org.eclipse.cdt.internal.ui.text.COperatorRule;
import org.eclipse.cdt.internal.ui.text.CWhitespaceRule;
import org.eclipse.cdt.internal.ui.text.NumberRule;
import org.eclipse.cdt.internal.ui.text.util.CWordDetector;
import org.eclipse.cdt.ui.text.AbstractCScanner;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CCodeScanner
extends AbstractCScanner {
    private static String[] fgTokenProperties = new String[]{"c_keyword", "c_type", "c_operators", "c_braces", "c_numbers", "c_default"};
    private ICLanguageKeywords fKeywords;

    public CCodeScanner(ITokenStoreFactory factory, ICLanguageKeywords keywords) {
        super(factory.createTokenStore(fgTokenProperties));
        this.fKeywords = keywords;
        this.setRules(this.createRules());
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        IToken token = this.getToken("c_default");
        rules.add(new CWhitespaceRule(token));
        WordRule wordRule = new WordRule((IWordDetector)new CWordDetector(), token);
        token = this.getToken("c_keyword");
        String[] keywords = this.fKeywords.getKeywords();
        int i = 0;
        while (i < keywords.length) {
            wordRule.addWord(keywords[i], token);
            ++i;
        }
        token = this.getToken("c_type");
        String[] types = this.fKeywords.getBuiltinTypes();
        int i2 = 0;
        while (i2 < types.length) {
            wordRule.addWord(types[i2], token);
            ++i2;
        }
        rules.add((IRule)wordRule);
        token = this.getToken("c_numbers");
        NumberRule numberRule = new NumberRule(token);
        rules.add(numberRule);
        token = this.getToken("c_operators");
        COperatorRule opRule = new COperatorRule(token);
        rules.add(opRule);
        token = this.getToken("c_braces");
        CBraceRule braceRule = new CBraceRule(token);
        rules.add(braceRule);
        this.setDefaultReturnToken(this.getToken("c_default"));
        return rules;
    }
}

