/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionProcessor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class CSelectAnnotationRulerAction
extends SelectMarkerRulerAction {
    private ITextEditor fTextEditor;
    private Position fPosition;
    private AnnotationPreferenceLookup fAnnotationPreferenceLookup;
    private IPreferenceStore fStore;
    private boolean fHasCorrection;
    private ResourceBundle fBundle;

    public CSelectAnnotationRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        this.fBundle = bundle;
        this.fTextEditor = editor;
        this.fAnnotationPreferenceLookup = EditorsUI.getAnnotationPreferenceLookup();
        this.fStore = CUIPlugin.getDefault().getCombinedPreferenceStore();
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.fHasCorrection) {
            ITextOperationTarget operation = (ITextOperationTarget)this.fTextEditor.getAdapter(ITextOperationTarget.class);
            if (operation != null && operation.canDoOperation(22)) {
                this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
                operation.doOperation(22);
            }
            return;
        }
        super.run();
    }

    public void update() {
        this.findCAnnotation();
        this.setEnabled(true);
        if (this.fHasCorrection) {
            this.initialize(this.fBundle, "CSelectAnnotationRulerAction.QuickFix.");
            return;
        }
        this.initialize(this.fBundle, "CSelectAnnotationRulerAction.GotoAnnotation.");
        super.update();
    }

    private void findCAnnotation() {
        this.fPosition = null;
        this.fHasCorrection = false;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension annotationAccess = this.getAnnotationAccessExtension();
        IDocument document = this.getDocument();
        if (model == null) {
            return;
        }
        Iterator iter = model.getAnnotationIterator();
        int layer = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            String key;
            boolean isReadOnly;
            Position position;
            Annotation annotation = (Annotation)iter.next();
            if (annotation.isMarkedDeleted()) continue;
            int annotationLayer = layer;
            if (annotationAccess != null && (annotationLayer = annotationAccess.getLayer(annotation)) < layer || !this.includesRulerLine(position = model.getPosition(annotation), document)) continue;
            boolean bl = isReadOnly = this.fTextEditor instanceof ITextEditorExtension && ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly();
            if (!isReadOnly && CCorrectionProcessor.hasCorrections(annotation)) {
                this.fPosition = position;
                this.fHasCorrection = true;
                layer = annotationLayer;
                continue;
            }
            AnnotationPreference preference = this.fAnnotationPreferenceLookup.getAnnotationPreference(annotation);
            if (preference == null || (key = preference.getVerticalRulerPreferenceKey()) == null || !this.fStore.getBoolean(key)) continue;
            this.fPosition = position;
            this.fHasCorrection = false;
            layer = annotationLayer;
        }
    }
}

