/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.text.spelling.Messages;
import org.eclipse.cdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.IInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class WordIgnoreProposal
implements ICCompletionProposal {
    private IInvocationContext fContext;
    private String fWord;

    public WordIgnoreProposal(String word, IInvocationContext context) {
        this.fWord = word;
        this.fContext = context;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker != null) {
            ISourceViewer sourceViewer;
            checker.ignoreWord(this.fWord);
            if (this.fContext instanceof IQuickAssistInvocationContext && (sourceViewer = ((IQuickAssistInvocationContext)this.fContext).getSourceViewer()) != null) {
                SpellingProblem.removeAll((ISourceViewer)sourceViewer, (String)this.fWord);
            }
        }
    }

    public String getAdditionalProposalInfo() {
        return Messages.bind((String)Messages.Spelling_ignore_info, (Object)WordCorrectionProposal.getHtmlRepresentation(this.fWord));
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.bind((String)Messages.Spelling_ignore_label, (Object)this.fWord);
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.never_translate.gif");
    }

    public final int getRelevance() {
        return -2147483647;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }

    public String getIdString() {
        return this.fWord;
    }
}

