/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public abstract class WatchPb
implements PBConstr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean ATMOST = false;
    public static final boolean ATLEAST = true;
    protected double activity;
    protected BigInteger[] coefs;
    protected BigInteger degree;
    protected int[] lits;
    protected boolean learnt = false;
    protected BigInteger watchCumul = BigInteger.ZERO;
    protected ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.WatchPb");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    WatchPb() {
    }

    WatchPb(IDataStructurePB iDataStructurePB) {
        int n = iDataStructurePB.size();
        this.lits = new int[n];
        this.coefs = new BigInteger[n];
        iDataStructurePB.buildConstraintFromMapPb(this.lits, this.coefs);
        this.degree = iDataStructurePB.getDegree();
        this.sort();
    }

    WatchPb(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        this.lits = nArray;
        this.coefs = bigIntegerArray;
        this.degree = bigInteger;
        this.sort();
    }

    public boolean isAssertive(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n2 = 0;
        while (n2 < this.lits.length) {
            if (!(this.coefs[n2].signum() <= 0 || this.voc.isFalsified(this.lits[n2]) && this.voc.getLevel(this.lits[n2]) < n)) {
                bigInteger = bigInteger.add(this.coefs[n2]);
            }
            ++n2;
        }
        if ((bigInteger = bigInteger.subtract(this.degree)).signum() < 0) {
            return false;
        }
        n2 = 0;
        while (n2 < this.lits.length) {
            if (this.coefs[n2].signum() > 0 && (this.voc.isUnassigned(this.lits[n2]) || this.voc.getLevel(this.lits[n2]) >= n) && bigInteger.compareTo(this.coefs[n2]) < 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        int[] nArray = this.lits;
        int n2 = this.lits.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            if (this.voc.isFalsified(n4)) {
                iVecInt.push(n4 ^ 1);
            }
            ++n3;
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    public int get(int n) {
        return this.lits[n];
    }

    public BigInteger getCoef(int n) {
        return this.coefs[n];
    }

    public double getActivity() {
        return this.activity;
    }

    public void incActivity(double d) {
        if (this.learnt) {
            this.activity += d;
        }
    }

    public BigInteger slackConstraint() {
        return this.recalcLeftSide().subtract(this.degree);
    }

    public BigInteger slackConstraint(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return this.recalcLeftSide(bigIntegerArray).subtract(bigInteger);
    }

    public BigInteger recalcLeftSide(BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[n])) {
                if (!$assertionsDisabled && bigIntegerArray[n].signum() < 0) {
                    throw new AssertionError();
                }
                bigInteger = bigInteger.add(bigIntegerArray[n]);
            }
            ++n;
        }
        return bigInteger;
    }

    public BigInteger recalcLeftSide() {
        return this.recalcLeftSide(this.coefs);
    }

    protected boolean isSatisfiable() {
        return this.recalcLeftSide().compareTo(this.degree) >= 0;
    }

    public boolean learnt() {
        return this.learnt;
    }

    public boolean locked() {
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (this.voc.getReason(n3) == this) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int n, int n2) {
        int n3 = n;
        while (n3 < n2 - 1) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n2) {
                if (this.coefs[n5].compareTo(this.coefs[n4]) > 0 || this.coefs[n5].equals(this.coefs[n4]) && this.lits[n5] > this.lits[n4]) {
                    n4 = n5;
                }
                ++n5;
            }
            BigInteger bigInteger = this.coefs[n3];
            this.coefs[n3] = this.coefs[n4];
            this.coefs[n4] = bigInteger;
            int n6 = this.lits[n3];
            this.lits[n3] = this.lits[n4];
            this.lits[n4] = n6;
            ++n3;
        }
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public boolean simplify() {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.lits.length && bigInteger.compareTo(this.degree) < 0) {
            if (this.voc.isSatisfied(this.lits[n])) {
                bigInteger = bigInteger.add(this.coefs[n]);
            }
            ++n;
        }
        return bigInteger.compareTo(this.degree) >= 0;
    }

    public final int size() {
        return this.lits.length;
    }

    protected final void sort() {
        if (!$assertionsDisabled && this.lits == null) {
            throw new AssertionError();
        }
        if (this.coefs.length > 0) {
            this.sort(0, this.size());
            BigInteger bigInteger = this.coefs[0];
            int n = 1;
            while (n < this.coefs.length) {
                if (!$assertionsDisabled && bigInteger.compareTo(this.coefs[n]) < 0) {
                    throw new AssertionError();
                }
                bigInteger = this.coefs[n];
                ++n;
            }
        }
    }

    protected final void sort(int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 15) {
            this.selectionSort(n, n2);
        } else {
            int n4 = n3 / 2 + n;
            BigInteger bigInteger = this.coefs[n4];
            int n5 = this.lits[n4];
            int n6 = n - 1;
            int n7 = n2;
            while (true) {
                if (this.coefs[++n6].compareTo(bigInteger) > 0 || this.coefs[n6].equals(bigInteger) && this.lits[n6] > n5) {
                    continue;
                }
                while (bigInteger.compareTo(this.coefs[--n7]) > 0 || this.coefs[n7].equals(bigInteger) && this.lits[n7] < n5) {
                }
                if (n6 >= n7) break;
                BigInteger bigInteger2 = this.coefs[n6];
                this.coefs[n6] = this.coefs[n7];
                this.coefs[n7] = bigInteger2;
                int n8 = this.lits[n6];
                this.lits[n6] = this.lits[n7];
                this.lits[n7] = n8;
            }
            this.sort(n, n6);
            this.sort(n6, n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lits.length > 0) {
            int n = 0;
            while (n < this.lits.length) {
                stringBuffer.append(" + ");
                stringBuffer.append(this.coefs[n]);
                stringBuffer.append(".");
                stringBuffer.append(Lits.toString((int)this.lits[n]));
                stringBuffer.append("[");
                stringBuffer.append(this.voc.valueToString(this.lits[n]));
                stringBuffer.append("@");
                stringBuffer.append(this.voc.getLevel(this.lits[n]));
                stringBuffer.append("]");
                stringBuffer.append(" ");
                ++n;
            }
            stringBuffer.append(">= ");
            stringBuffer.append(this.degree);
        }
        return stringBuffer.toString();
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        BigInteger bigInteger = this.slackConstraint();
        int n = 0;
        while (n < this.lits.length) {
            if (this.voc.isUnassigned(this.lits[n]) && bigInteger.compareTo(this.coefs[n]) < 0) {
                boolean bl = unitPropagationListener.enqueue(this.lits[n], (Constr)this);
                if (!$assertionsDisabled && !bl) {
                    throw new AssertionError();
                }
            }
            ++n;
        }
    }

    public BigInteger getDegree() {
        return this.degree;
    }

    public void register() {
        block3: {
            if (!$assertionsDisabled && !this.learnt) {
                throw new AssertionError();
            }
            try {
                this.computeWatches();
            }
            catch (ContradictionException contradictionException) {
                System.out.println(this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public BigInteger[] getCoefs() {
        BigInteger[] bigIntegerArray = new BigInteger[this.coefs.length];
        System.arraycopy(this.coefs, 0, bigIntegerArray, 0, this.coefs.length);
        return bigIntegerArray;
    }

    public int[] getLits() {
        int[] nArray = new int[this.lits.length];
        System.arraycopy(this.lits, 0, nArray, 0, this.lits.length);
        return nArray;
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public IVecInt computeAnImpliedClause() {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = this.coefs.length;
        while (bigInteger.compareTo(this.degree) > 0 && n > 0) {
            bigInteger = bigInteger.add(this.coefs[--n]);
        }
        if (n > 0 && n < this.size() / 2) {
            VecInt vecInt = new VecInt(n);
            int n2 = 0;
            while (n2 <= n) {
                vecInt.push(this.lits[n2]);
                ++n2;
            }
            return vecInt;
        }
        return null;
    }

    public boolean coefficientsEqualToOne() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            WatchPb watchPb = (WatchPb)object;
            if (!this.degree.equals(watchPb.degree) || this.coefs.length != watchPb.coefs.length || this.lits.length != watchPb.lits.length) {
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= this.coefs.length) {
                    return true;
                }
                int n2 = this.lits[n];
                boolean bl = false;
                int n3 = 0;
                while (n3 < this.coefs.length) {
                    if (watchPb.lits[n3] == n2) {
                        if (!watchPb.coefs[n3].equals(this.coefs[n])) {
                            return false;
                        }
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 0L;
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            l += (long)n3;
            ++n2;
        }
        return (int)l / this.lits.length;
    }

    public void forwardActivity(double d) {
        if (!this.learnt) {
            this.activity += d;
        }
    }
}

