/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ScannerConfigNature
implements IProjectNature {
    public static final String NATURE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".ScannerConfigNature";
    private IProject fProject;

    public void configure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(ScannerConfigBuilder.BUILDER_ID)) {
                return;
            }
            ++i;
        }
        ICommand command = description.newCommand();
        command.setBuilderName(ScannerConfigBuilder.BUILDER_ID);
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        newCommands[commands.length] = command;
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(ScannerConfigBuilder.BUILDER_ID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                break;
            }
            ++i;
        }
        this.getProject().setDescription(description, null);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public static void addScannerConfigNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (description.hasNature(NATURE_ID)) {
            return;
        }
        String[] ids = description.getNatureIds();
        String[] newIds = new String[ids.length + 1];
        System.arraycopy(ids, 0, newIds, 0, ids.length);
        newIds[ids.length] = NATURE_ID;
        description.setNatureIds(newIds);
        project.setDescription(description, null);
    }

    public static void removeScannerConfigNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (!description.hasNature(NATURE_ID)) {
            return;
        }
        String[] ids = description.getNatureIds();
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(NATURE_ID)) {
                String[] newIds = new String[ids.length - 1];
                System.arraycopy(ids, 0, newIds, 0, i);
                System.arraycopy(ids, i + 1, newIds, i, ids.length - i - 1);
                description.setNatureIds(newIds);
                project.setDescription(description, null);
            }
            ++i;
        }
    }

    public static ICommand getBuildSpec(IProjectDescription description, String builderID) {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public static IProjectDescription setBuildSpec(IProjectDescription description, ICommand newCommand) {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldCommand = ScannerConfigNature.getBuildSpec(description, newCommand.getBuilderName());
        if (oldCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = newCommand;
        } else {
            int i = 0;
            while (i < oldCommands.length) {
                if (oldCommands[i] == oldCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        return description;
    }

    public static void initializeDiscoveryOptions(IProject project) {
        try {
            IScannerConfigBuilderInfo2 scPrefInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2(MakeCorePlugin.getDefault().getPluginPreferences(), false);
            String selectedProfile = scPrefInfo.getSelectedProfileId();
            IScannerConfigBuilderInfo2 scProjInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2(project, selectedProfile);
            scProjInfo.setAutoDiscoveryEnabled(scPrefInfo.isAutoDiscoveryEnabled());
            scProjInfo.setProblemReportingEnabled(scPrefInfo.isProblemReportingEnabled());
            scProjInfo.setBuildOutputParserEnabled(scPrefInfo.isBuildOutputParserEnabled());
            scProjInfo.setBuildOutputFileActionEnabled(scPrefInfo.isBuildOutputFileActionEnabled());
            scProjInfo.setBuildOutputFilePath(scPrefInfo.getBuildOutputFilePath());
            ScannerConfigProfile profile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(selectedProfile);
            List<String> providerIdList = scPrefInfo.getProviderIdList();
            for (String providerId : providerIdList) {
                scProjInfo.setProviderOutputParserEnabled(providerId, scPrefInfo.isProviderOutputParserEnabled(providerId));
                if (profile.getScannerInfoProviderElement(providerId).getProviderKind().equals("run")) {
                    scProjInfo.setProviderRunCommand(providerId, scPrefInfo.getProviderRunCommand(providerId));
                    scProjInfo.setProviderRunArguments(providerId, scPrefInfo.getProviderRunArguments(providerId));
                    continue;
                }
                scProjInfo.setProviderOpenFilePath(providerId, scPrefInfo.getProviderOpenFilePath(providerId));
            }
            scProjInfo.save();
            ICProject cProject = CoreModel.getDefault().create(project);
            IPathEntry[] rawPathEntries = CoreModel.getRawPathEntries((ICProject)cProject);
            boolean found = false;
            int i = 0;
            while (i < rawPathEntries.length) {
                IContainerEntry container;
                if (rawPathEntries[i].getEntryKind() == 32 && (container = (IContainerEntry)rawPathEntries[i]).getPath().equals((Object)DiscoveredPathContainer.CONTAINER_ID)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                IPathEntry[] newRawPathEntries = new IPathEntry[rawPathEntries.length + 1];
                System.arraycopy(rawPathEntries, 0, newRawPathEntries, 0, rawPathEntries.length);
                newRawPathEntries[rawPathEntries.length] = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
                CoreModel.setRawPathEntries((ICProject)cProject, (IPathEntry[])newRawPathEntries, null);
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
    }
}

