/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ShutdownSequence
extends Sequence {
    String fSessionId;
    String fApplicationName;
    String fDebugModelId;
    DsfServicesTracker fTracker;
    private final Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            if (!$assertionsDisabled && GdbPlugin.getBundleContext() == null) {
                throw new AssertionError();
            }
            ShutdownSequence.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), ShutdownSequence.this.fSessionId);
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IDisassembly.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IRegisters.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIBreakpointsManager.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IBreakpoints.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(ISourceLookup.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IExpressions.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IStack.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IModules.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IMemory.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IRunControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IProcesses.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(ICommandControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IMIBackend.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};

    public ShutdownSequence(DsfExecutor executor, String sessionId, RequestMonitor requestMonitor) {
        super(executor, requestMonitor);
        this.fSessionId = sessionId;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private void shutdownService(Class clazz, final RequestMonitor requestMonitor) {
        IDsfService service = (IDsfService)this.fTracker.getService(clazz);
        if (service != null) {
            service.shutdown(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        GdbPlugin.getDefault().getLog().log(this.getStatus());
                    }
                    requestMonitor.done();
                }
            });
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Service '" + clazz.getName() + "' not found.", null));
            requestMonitor.done();
        }
    }
}

